/*
 * Decompiled with CFR 0.152.
 */
package com.midnight.liteloaderloader.core.transformers;

import com.midnight.liteloaderloader.core.LiteloaderLoader;
import com.midnight.liteloaderloader.core.SafeClassWriter;
import java.util.HashMap;
import java.util.function.Consumer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class ClassTransformer {
    protected final HashMap<String, Consumer<MethodNode>> methodTransforms = new HashMap();

    public byte[] apply(byte[] classBytes) {
        ClassReader reader = new ClassReader(classBytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!this.methodTransforms.containsKey(method.name)) continue;
            LiteloaderLoader.LOG.info("Transforming method: {} in class: {}", new Object[]{method.name, node.name});
            int insCount = method.instructions.size();
            this.methodTransforms.get(method.name).accept(method);
            LiteloaderLoader.LOG.info("Transformed {}. Instruction count: {} (was {})", new Object[]{method.name, method.instructions.size(), insCount});
        }
        SafeClassWriter writer = new SafeClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

