/*
 * Decompiled with CFR 0.152.
 */
package com.midnight.liteloaderloader.core.transformers;

import com.midnight.liteloaderloader.core.LiteloaderLoader;
import com.midnight.liteloaderloader.core.transformers.ClassTransformerTransformer;
import com.midnight.liteloaderloader.core.transformers.compat.AngelicaHUDCachingTransformer;
import com.midnight.liteloaderloader.core.transformers.compat.InputHandlerTransformer;
import com.midnight.liteloaderloader.core.transformers.compat.VoxelCommonLiteModTransformer;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.launchwrapper.IClassTransformer;

public class LLLTransformer
implements IClassTransformer {
    private static final HashMap<String, Function<byte[], byte[]>> transformations = new HashMap();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (transformations.containsKey(transformedName)) {
            LiteloaderLoader.LOG.info("Applying transformation for {}", new Object[]{transformedName});
            basicClass = transformations.get(transformedName).apply(basicClass);
        }
        return basicClass;
    }

    static {
        transformations.put("com.gtnewhorizons.angelica.hudcaching.HUDCaching", bytes -> new AngelicaHUDCachingTransformer().apply((byte[])bytes));
        transformations.put("com.thevoxelbox.common.VoxelCommonLiteMod", bytes -> new VoxelCommonLiteModTransformer().apply((byte[])bytes));
        transformations.put("net.eq2online.macros.input.InputHandler", bytes -> new InputHandlerTransformer().apply((byte[])bytes));
        transformations.put("com.mumfrey.liteloader.transformers.ClassTransformer", bytes -> new ClassTransformerTransformer().apply((byte[])bytes));
    }
}

