/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.autodisconector.client;

import com.blocklegend001.autodisconector.config.ModConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_418;

public class AutoDisconectorClient
implements ClientModInitializer {
    private long deathTime = 0L;
    private long postRespawnKickTime = 0L;
    private boolean wasDead = false;
    private boolean respawnedAfterDeath = false;
    private int deathCount = 0;
    private boolean ignoreNextDeathAfterJoin = true;
    private static final long KICK_DELAY_AFTER_RESPAWN = 500L;

    public void onInitializeClient() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            this.deathCount = 0;
            this.wasDead = false;
            this.respawnedAfterDeath = false;
            this.deathTime = 0L;
            this.postRespawnKickTime = 0L;
            this.ignoreNextDeathAfterJoin = true;
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            this.wasDead = false;
            this.respawnedAfterDeath = false;
            this.deathTime = 0L;
            this.postRespawnKickTime = 0L;
            this.ignoreNextDeathAfterJoin = true;
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null || client.field_1687 == null) {
                return;
            }
            if (client.field_1755 instanceof class_418 && this.ignoreNextDeathAfterJoin) {
                client.method_1507(null);
                this.ignoreNextDeathAfterJoin = false;
                this.wasDead = false;
                this.deathTime = 0L;
                this.respawnedAfterDeath = false;
                return;
            }
            boolean inDeathScreen = client.field_1755 instanceof class_418;
            if (inDeathScreen) {
                if (!this.wasDead) {
                    this.wasDead = true;
                    this.deathTime = System.currentTimeMillis();
                    this.respawnedAfterDeath = false;
                    ++this.deathCount;
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cDeath: \u00a7e" + this.deathCount + "\u00a77/\u00a7e" + ModConfig.MaxDeathKick)), false);
                }
            } else {
                if (this.wasDead && !this.respawnedAfterDeath) {
                    this.respawnedAfterDeath = true;
                    this.postRespawnKickTime = System.currentTimeMillis();
                }
                this.wasDead = false;
            }
            if (!this.respawnedAfterDeath && this.wasDead && System.currentTimeMillis() - this.deathTime >= (long)ModConfig.RespawnDelay) {
                client.field_1724.method_7331();
                client.method_1507(null);
            }
            if (this.respawnedAfterDeath && this.deathCount >= ModConfig.MaxDeathKick && System.currentTimeMillis() - this.postRespawnKickTime >= 500L) {
                client.field_1724.field_3944.method_48296().method_10747((class_2561)class_2561.method_43470((String)""));
            }
        });
    }
}

