/*
 * Decompiled with CFR 0.152.
 */
package net.riotzero.arbitrarydelight.util.effect;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.riotzero.arbitrarydelight.registry.EffectRegistry;

public class UnstableChorusEffect
extends MobEffect {
    public UnstableChorusEffect() {
        super(MobEffectCategory.NEUTRAL, 10105549);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        ServerPlayer player;
        MobEffectInstance effect;
        if (!entity.level().isClientSide && entity instanceof ServerPlayer && (effect = (player = (ServerPlayer)entity).getEffect(EffectRegistry.UNSTABLE_CHORUS)) != null && effect.getDuration() == 1) {
            this.chorusFruitTeleport(player);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    private void chorusFruitTeleport(ServerPlayer player) {
        RandomSource random = player.getRandom();
        double startX = player.getX();
        double startY = player.getY();
        double startZ = player.getZ();
        for (int i = 0; i < 16; ++i) {
            double targetZ;
            double targetY;
            double targetX = startX + (random.nextDouble() - 0.5) * 16.0;
            if (!player.randomTeleport(targetX, targetY = Mth.clamp((double)(startY + (double)(random.nextInt(16) - 8)), (double)player.level().getMinBuildHeight(), (double)(player.level().getMaxBuildHeight() - 1)), targetZ = startZ + (random.nextDouble() - 0.5) * 16.0, true)) continue;
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, player.getRandom().nextFloat() * 0.4f + 0.8f);
            break;
        }
    }
}

