/*
 * Decompiled with CFR 0.152.
 */
package net.riotzero.arbitrarydelight.util.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ChorusFruitCustardItem
extends Item {
    public ChorusFruitCustardItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack result = super.finishUsingItem(stack, level, entity);
        if (!level.isClientSide) {
            double startX = entity.getX();
            double startY = entity.getY();
            double startZ = entity.getZ();
            for (int i = 0; i < 16; ++i) {
                double newX = startX + (entity.getRandom().nextDouble() - 0.5) * 16.0;
                double newY = Mth.clamp((double)(startY + (double)(entity.getRandom().nextInt(16) - 8)), (double)level.getMinBuildHeight(), (double)(level.getMaxBuildHeight() - 1));
                double newZ = startZ + (entity.getRandom().nextDouble() - 0.5) * 16.0;
                if (entity.isPassenger()) {
                    entity.stopRiding();
                }
                if (!entity.randomTeleport(newX, newY, newZ, true)) continue;
                level.playSound(null, startX, startY, startZ, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.getCooldowns().addCooldown((Item)this, 10);
            }
        }
        return result;
    }
}

