package dev.gegy.roles.mixin;

import com.mojang.brigadier.CommandDispatcher;
import dev.gegy.roles.IdentifiableCommandSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import net.minecraft.class_2158;
import net.minecraft.class_2960;
import net.minecraft.class_8839;

@Mixin(class_2158.class)
public interface CommandFunctionMixin {
    @Inject(method = "create", at = @At("HEAD"))
    private static void create(
            class_2960 id, CommandDispatcher<class_8839> dispatcher,
            class_8839 source, List<String> lines,
            CallbackInfoReturnable<class_2158> ci
    ) {
        var identifiableSource = (IdentifiableCommandSource) source;
        identifiableSource.player_roles$setIdentityType(IdentifiableCommandSource.Type.FUNCTION);
    }
}
