package dev.gegy.roles.mixin;

import dev.gegy.roles.store.PlayerRoleManager;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3324.class)
public class PlayerManagerMixin {
    @Inject(method = "onPlayerConnect", at = @At("HEAD"))
    private void onPlayerConnect(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        var roleManager = PlayerRoleManager.get();
        roleManager.onPlayerJoin(player);
    }

    @Inject(method = "remove", at = @At("HEAD"))
    private void onPlayerDisconnect(class_3222 player, CallbackInfo ci) {
        var roleManager = PlayerRoleManager.get();
        roleManager.onPlayerLeave(player);
    }
}
