package dev.gegy.roles.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import dev.gegy.roles.store.PlayerRoleManager;
import net.minecraft.class_11368;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_3222.class, priority = 900)
public abstract class ServerPlayerEntityMixin extends class_1657 {
    private ServerPlayerEntityMixin(class_1937 world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(method = "readCustomData", at = @At("RETURN"))
    private void readLegacyRolesData(class_11368 view, CallbackInfo ci) {
        view.method_71426("roles", Codec.STRING.listOf()).ifPresent(names -> {
            PlayerRoleManager.get().addLegacyRoles((class_3222) (Object) this, names);
        });
    }
}
