package dev.gegy.roles.mixin.command;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.gegy.roles.PlayerRoles;
import dev.gegy.roles.api.PlayerRolesApi;
import net.minecraft.class_11560;
import net.minecraft.class_2168;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_2168.class)
public class ServerCommandSourceMixin {
    @WrapOperation(
            method = "sendToOps",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/PlayerManager;isOperator(Lnet/minecraft/server/PlayerConfigEntry;)Z"
            )
    )
    private boolean shouldReceiveCommandFeedback(class_3324 playerManager, class_11560 profile, Operation<Boolean> original) {
        if (original.call(playerManager, profile)) {
            return true;
        }

        var player = playerManager.method_14602(profile.comp_4422());
        var roles = PlayerRolesApi.lookup().byPlayer(player);
        return roles.overrides().test(PlayerRoles.COMMAND_FEEDBACK);
    }
}
