package dev.gegy.roles.mixin.entity_selectors;

import dev.gegy.roles.PlayerRoles;
import dev.gegy.roles.api.PlayerRolesApi;
import net.minecraft.class_2168;
import net.minecraft.class_2300;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_2300.class)
public class EntitySelectorMixin {
    @Redirect(method = "checkSourcePermission", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/command/ServerCommandSource;hasElevatedPermissions()Z"))
    private boolean hasPermissionLevel(class_2168 instance) {
        if (instance.method_71775()) {
            return true;
        }

        var roles = PlayerRolesApi.lookup().bySource(instance);
        return roles.overrides().test(PlayerRoles.ENTITY_SELECTORS);
    }
}
