package dev.gegy.roles.mixin.name_decoration;

import com.mojang.authlib.GameProfile;
import dev.gegy.roles.PlayerRoles;
import dev.gegy.roles.api.PlayerRolesApi;
import dev.gegy.roles.mixin.TeamAccessor;
import dev.gegy.roles.override.NameDecorationOverride;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

// Bump priority to apply name decorations after other mods
@Mixin(value = class_3222.class, priority = 1001)
public abstract class ServerPlayerEntityMixin extends class_1657 {
    private ServerPlayerEntityMixin(class_1937 world, GameProfile profile) {
        super(world, profile);
    }

    @Override
    public class_2561 method_5476() {
        var displayName = super.method_5476();

        var team = this.method_5781();
        if (team == null || ((TeamAccessor) team).getFormattingColor() == class_124.field_1070) {
            var roles = PlayerRolesApi.lookup().byPlayer(this);

            var nameDecoration = roles.overrides().select(PlayerRoles.NAME_DECORATION);
            if (nameDecoration != null) {
                displayName = nameDecoration.apply(displayName.method_27661(), NameDecorationOverride.Context.CHAT);
            }
        }

        return displayName;
    }

    @Inject(method = "getPlayerListName", at = @At("RETURN"), cancellable = true)
    private void getPlayerListName(CallbackInfoReturnable<class_2561> cir) {
        var roles = PlayerRolesApi.lookup().byPlayer(this);

        var nameDecoration = roles.overrides().select(PlayerRoles.NAME_DECORATION);
        if (nameDecoration != null) {
            var currentName = cir.getReturnValue();
            if (currentName != null) {
                cir.setReturnValue(nameDecoration.apply(currentName.method_27661(), NameDecorationOverride.Context.TAB_LIST));
            } else {
                cir.setReturnValue(nameDecoration.apply(class_2561.method_43470(method_7334().name()), NameDecorationOverride.Context.TAB_LIST));
            }
        }
    }
}
