package dev.gegy.roles.override;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.codecs.MoreCodecs;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_8824;

public record NameDecorationOverride(
		Optional<AddPrefix> prefix,
		Optional<AddSuffix> suffix,
		Optional<ApplyStyle> applyStyle,
		Optional<OnHover> onHover,
		EnumSet<Context> contexts
) {
	private static final EnumSet<Context> DEFAULT_CONTEXTS = EnumSet.allOf(Context.class);

	public static final Codec<NameDecorationOverride> CODEC = RecordCodecBuilder.create(i -> i.group(
			AddPrefix.CODEC.optionalFieldOf("prefix").forGetter(NameDecorationOverride::prefix),
			AddSuffix.CODEC.optionalFieldOf("suffix").forGetter(NameDecorationOverride::suffix),
			ApplyStyle.CODEC.optionalFieldOf("style").forGetter(NameDecorationOverride::applyStyle),
			OnHover.CODEC.optionalFieldOf("hover").forGetter(NameDecorationOverride::onHover),
			Context.SET_CODEC.optionalFieldOf("contexts", DEFAULT_CONTEXTS).forGetter(NameDecorationOverride::contexts)
	).apply(i, NameDecorationOverride::new));

	public class_5250 apply(class_5250 name, Context context) {
		if (!this.contexts.contains(context)) {
			return name;
		}
		if (this.applyStyle.isPresent()) {
			name = this.applyStyle.get().apply(name);
		}
		if (this.onHover.isPresent()) {
			name = this.onHover.get().apply(name);
		}
		if (this.prefix.isPresent()) {
			name = this.prefix.get().apply(name);
		}
		if (this.suffix.isPresent()) {
			name = this.suffix.get().apply(name);
		}
		return name;
	}

	public record AddPrefix(class_2561 prefix) {
		public static final Codec<AddPrefix> CODEC = class_8824.field_46597.xmap(AddPrefix::new, AddPrefix::prefix);

		public class_5250 apply(final class_5250 name) {
			return class_2561.method_43473().method_10852(this.prefix).method_10852(name);
		}
	}

	public record AddSuffix(class_2561 suffix) {
		public static final Codec<AddSuffix> CODEC = class_8824.field_46597.xmap(AddSuffix::new, AddSuffix::suffix);

		public class_5250 apply(final class_5250 name) {
			return name.method_10852(this.suffix);
		}
	}

	public record ApplyStyle(class_124[] formats, @Nullable class_5251 color) {
		public static final Codec<ApplyStyle> CODEC = MoreCodecs.listOrUnit(Codec.STRING).xmap(
				formatKeys -> {
					List<class_124> formats = new ArrayList<>();
					class_5251 color = null;

					for (String formatKey : formatKeys) {
						var format = class_124.method_533(formatKey);
						if (format != null) {
							formats.add(format);
						} else {
							var parsedColor = class_5251.method_27719(formatKey).result();
							if (parsedColor.isPresent()) {
								color = parsedColor.get();
							}
						}
					}

					return new ApplyStyle(formats.toArray(new class_124[0]), color);
				},
				override -> {
					List<String> formatKeys = new ArrayList<>();
					if (override.color != null) {
						formatKeys.add(override.color.method_27721());
					}

					for (var format : override.formats) {
						formatKeys.add(format.method_537());
					}

					return formatKeys;
				}
		);

		public class_5250 apply(class_5250 text) {
			return text.method_10862(this.applyStyle(text.method_10866()));
		}

		private class_2583 applyStyle(class_2583 style) {
			style = style.method_27705(this.formats);
			if (this.color != null) {
				style = style.method_27703(this.color);
			}
			return style;
		}
	}

	public record OnHover(class_2568 event) {
		private static final Codec<OnHover> CODEC = class_2568.field_46601.xmap(OnHover::new, OnHover::event);
		public class_5250 apply(class_5250 text) {
			return text.method_10862(text.method_10866().method_10949(this.event));
		}
	}

	public enum Context implements class_3542 {
		CHAT("chat"),
		TAB_LIST("tab_list"),
		;

		public static final com.mojang.serialization.Codec<Context> CODEC = class_3542.method_28140(Context::values);

		public static final com.mojang.serialization.Codec<EnumSet<Context>> SET_CODEC = Context.CODEC.listOf().comapFlatMap(list -> {
			var set = EnumSet.noneOf(Context.class);
			for (var context : list) {
				if (!set.add(context)) {
					return DataResult.error(() -> "Duplicate entry in set: " + context.name());
				}
			}
			return DataResult.success(set);
		}, ArrayList::new);

		private final String name;

		Context(final String name) {
			this.name = name;
		}

		@Override
		public String method_15434() {
			return this.name;
		}
	}
}
