/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.i_have_slept.mixin;

import dev.aika.i_have_slept.IHaveSlept;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Shadow
    public abstract GameRules getGameRules();

    @Shadow
    public abstract List<ServerPlayer> getPlayers(Predicate<? super ServerPlayer> var1);

    @Inject(method={"tick(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;wakeUpAllPlayers()V", shift=At.Shift.AFTER)})
    private void onTick(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        if (!this.getGameRules().getBoolean(IHaveSlept.BETTER_SERVER_SLEEP)) {
            return;
        }
        this.getPlayers(player -> {
            IHaveSlept.LOGGER.info("Resetting time since rest for player {}", (Object)player.getName().getString());
            player.resetStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST));
            return true;
        });
    }
}

