/*
 * Decompiled with CFR 0.152.
 */
package com.kekie6.colorfulazaleas.datagen;

import com.kekie6.colorfulazaleas.ColorfulAzaleas;
import com.kekie6.colorfulazaleas.registry.AzaleaBlocks;
import com.kekie6.colorfulazaleas.registry.AzaleaItems;
import com.kekie6.colorfulazaleas.util.AzaleaColors;
import com.kekie6.colorfulazaleas.util.ColorfulTree;
import com.kekie6.colorfulazaleas.util.WoodSet;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1792;
import net.minecraft.class_7225;

public class ModLanguageProvider
extends FabricLanguageProvider {
    public ModLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, "en_us", registryLookup);
    }

    public void generateTranslations(class_7225.class_7874 wrapperLookup, FabricLanguageProvider.TranslationBuilder builder) {
        ColorfulAzaleas.LOGGER.info("Generating en_us for colorfulazaleas");
        if (AzaleaBlocks.trees == null) {
            AzaleaBlocks.init();
        }
        for (ColorfulTree colorfulTree : AzaleaBlocks.trees) {
            AzaleaColors color = colorfulTree.getColor();
            String colorName = ModLanguageProvider.capitalize(color.name().replace("_", " "));
            String title = ModLanguageProvider.capitalize(color.getTitle());
            builder.add(colorfulTree.getAzaleaLeaves(), colorName + " Azalea Leaves");
            builder.add(colorfulTree.getFloweringLeaves(), "Flowering " + colorName + " Azalea Leaves");
            builder.add(colorfulTree.getBloomingLeaves(), "Blooming " + colorName + " Azalea Leaves");
            builder.add(colorfulTree.getDroopingLeaves(), "Drooping " + colorName + " Azalea Leaves");
            builder.add(colorfulTree.getSapling(), colorName + " Azalea Sapling");
            builder.add(colorfulTree.getPottedSapling(), "Potted " + colorName + " Azalea Sapling");
            WoodSet woodSet = colorfulTree.getWoodSet();
            if (woodSet == null) continue;
            builder.add(woodSet.getLog(), title + " Azalea Log");
            builder.add(woodSet.getWood(), title + " Azalea Wood");
            builder.add(woodSet.getStrippedLog(), "Stripped " + title + " Azalea Log");
            builder.add(woodSet.getStrippedWood(), "Stripped " + title + " Azalea Wood");
            builder.add(woodSet.getPlanks(), title + " Azalea Planks");
            builder.add(woodSet.getStairs(), title + " Azalea Stairs");
            builder.add(woodSet.getSlab(), title + " Azalea Slab");
            builder.add(woodSet.getFence(), title + " Azalea Fence");
            builder.add(woodSet.getFenceGate(), title + " Azalea Fence Gate");
            builder.add(woodSet.getDoor(), title + " Azalea Door");
            builder.add(woodSet.getTrapdoor(), title + " Azalea Trapdoor");
            builder.add(woodSet.getPressurePlate(), title + " Azalea Pressure Plate");
            builder.add(woodSet.getButton(), title + " Azalea Button");
            builder.add(woodSet.getSign(), title + " Azalea Sign");
            builder.add(woodSet.getWallSign(), title + " Azalea Wall Sign");
            builder.add(woodSet.getHangingSign(), title + " Azalea Hanging Sign");
            builder.add(woodSet.getWallHangingSign(), title + " Azalea Wall Hanging Sign");
            builder.add((class_1792)woodSet.getBoatItem(), title + " Azalea Boat");
            builder.add((class_1792)woodSet.getChestBoatItem(), title + " Azalea Boat with Chest");
            builder.add("entity.colorfulazaleas." + woodSet.getWoodSet() + "_azalea_chest_boat", title + " Azalea Boat with Chest");
            builder.add(woodSet.getShelf(), title + " Azalea Shelf");
        }
        builder.add(AzaleaItems.ICON_ITEM, "\u00a7fC\u00a76o\u00a7dl\u00a7bo\u00a7er\u00a7af\u00a7cu\u00a79l \u00a7dA\u00a7ez\u00a7aa\u00a7bl\u00a7ce\u00a7ea\u00a7fs\u00a76!");
        builder.add("itemGroup.colorfulazaleas.colorful_azaleas", "Colorful Azaleas");
        builder.add("tag.colorfulazaleas.azaleas", "Azaleas");
        builder.add("tag.colorfulazaleas.azalea_logs", "Azalea Logs");
        for (AzaleaColors azaleaColors : AzaleaColors.values()) {
            String title = ModLanguageProvider.capitalize(azaleaColors.getTitle());
            builder.add("tag.colorfulazaleas." + azaleaColors.getTitle() + "_azalea_logs", title + " Azalea Logs");
        }
    }

    private static String capitalize(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String[] words = input.toLowerCase().split(" ");
        StringBuilder result = new StringBuilder();
        for (String w : words) {
            if (w.isEmpty()) continue;
            result.append(Character.toUpperCase(w.charAt(0))).append(w.substring(1)).append(" ");
        }
        return result.toString().trim();
    }
}

