/*
 * Decompiled with CFR 0.152.
 */
package com.kekie6.colorfulazaleas.datagen;

import com.kekie6.colorfulazaleas.ColorfulAzaleas;
import com.kekie6.colorfulazaleas.block.DroopingLeavesBlock;
import com.kekie6.colorfulazaleas.registry.AzaleaBlocks;
import com.kekie6.colorfulazaleas.registry.AzaleaItems;
import com.kekie6.colorfulazaleas.util.ColorfulTree;
import com.kekie6.colorfulazaleas.util.WoodSet;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_7923;
import net.minecraft.class_807;

public class ModModelProvider
extends FabricModelProvider {
    public ModModelProvider(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(class_4910 gen) {
        ColorfulAzaleas.LOGGER.info("Generating BlockState models for colorfulazaleas");
        for (ColorfulTree tree : AzaleaBlocks.trees) {
            WoodSet woodSet = tree.getWoodSet();
            gen.method_25622(tree.getAzaleaLeaves(), class_4946.field_23049);
            gen.method_25622(tree.getFloweringLeaves(), class_4946.field_23049);
            ModModelProvider.registerBloomingAzaleaLeaves(gen, tree.getBloomingLeaves());
            ModModelProvider.registerDroopingLeavesVariants(gen, tree.getDroopingLeaves());
            gen.method_33713(tree.getSapling());
            ModModelProvider.registerPottedAzaleaWithUnpottedSideTop(gen, tree.getPottedSapling());
            gen.method_25676(woodSet.getLog()).method_25730(woodSet.getLog()).method_25728(woodSet.getWood());
            gen.method_25676(woodSet.getStrippedLog()).method_25730(woodSet.getStrippedLog()).method_25728(woodSet.getStrippedWood());
            class_4910.class_4912 plankPool = gen.method_25650(woodSet.getPlanks());
            plankPool.method_25725(woodSet.getStairs());
            plankPool.method_25724(woodSet.getSlab());
            plankPool.method_25721(woodSet.getFence());
            plankPool.method_25722(woodSet.getFenceGate());
            plankPool.method_25723(woodSet.getPressurePlate());
            plankPool.method_25716(woodSet.getButton());
            gen.method_25658(woodSet.getDoor());
            gen.method_25671(woodSet.getTrapdoor());
            ModModelProvider.registerSign(gen, woodSet.getSign(), woodSet.getWallSign());
            gen.method_46190(woodSet.getStrippedLog(), woodSet.getHangingSign(), woodSet.getWallHangingSign());
            gen.method_72719(woodSet.getShelf(), woodSet.getStrippedLog());
        }
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
        ColorfulAzaleas.LOGGER.info("Generating Item models for colorfulazaleas");
        itemModelGenerator.method_65442(AzaleaItems.ICON_ITEM, class_4943.field_22939);
        for (ColorfulTree tree : AzaleaBlocks.trees) {
            WoodSet woodSet = tree.getWoodSet();
            class_1792 droopingItem = tree.getDroopingLeaves().method_8389();
            class_2960 droopingItemId = class_7923.field_41178.method_10221((Object)tree.getDroopingLeaves().method_8389());
            class_4944 textures = new class_4944().method_25868(class_4945.field_23006, class_2960.method_60655((String)droopingItemId.method_12836(), (String)("block/" + droopingItemId.method_12832())));
            class_4943.field_22938.method_48525(droopingItem, textures, itemModelGenerator.field_55246);
            itemModelGenerator.method_65442((class_1792)woodSet.getBoatItem(), class_4943.field_22938);
            itemModelGenerator.method_65442((class_1792)woodSet.getChestBoatItem(), class_4943.field_22938);
        }
    }

    private static void registerPottedAzaleaWithUnpottedSideTop(class_4910 gen, class_2248 pottedBlock) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)pottedBlock);
        String namespace = blockId.method_12836();
        String path = blockId.method_12832();
        String unpottedPath = path.replaceFirst("^potted_", "");
        class_2960 plantTex = class_4944.method_25866((class_2248)pottedBlock, (String)"_plant");
        class_2960 sideTex = class_2960.method_60655((String)namespace, (String)("block/" + unpottedPath + "_side"));
        class_2960 topTex = class_2960.method_60655((String)namespace, (String)("block/" + unpottedPath + "_top"));
        class_4944 textures = new class_4944().method_25868(class_4945.field_23026, plantTex).method_25868(class_4945.field_23018, sideTex).method_25868(class_4945.field_23015, topTex);
        class_2960 modelId = class_4943.field_33965.method_25846(pottedBlock, textures, gen.field_22831);
        gen.field_22830.accept(class_4910.method_25644((class_2248)pottedBlock, (class_807)class_4910.method_67835((class_2960)modelId)));
    }

    private static void registerBloomingAzaleaLeaves(class_4910 gen, class_2248 bloomingLeaves) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)bloomingLeaves);
        String namespace = blockId.method_12836();
        String path = blockId.method_12832();
        String color = path.replace("_blooming_azalea_leaves", "");
        class_2960 bottomTex = class_2960.method_60655((String)namespace, (String)("block/" + color + "_azalea_leaves"));
        class_2960 topTex = class_2960.method_60655((String)namespace, (String)("block/" + color + "_flowering_azalea_leaves"));
        class_2960 sideTex = class_2960.method_60655((String)namespace, (String)("block/" + color + "_blooming_azalea_leaves"));
        class_4944 textures = new class_4944().method_25868(class_4945.field_23012, bottomTex).method_25868(class_4945.field_23014, bottomTex).method_25868(class_4945.field_23015, topTex).method_25868(class_4945.field_23018, sideTex);
        class_2960 modelId = class_4943.field_22977.method_25846(bloomingLeaves, textures, gen.field_22831);
        gen.field_22830.accept(class_4910.method_25644((class_2248)bloomingLeaves, (class_807)class_4910.method_67835((class_2960)modelId)));
    }

    private static void registerDroopingLeavesVariants(class_4910 gen, class_2248 droopingBlock) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)droopingBlock);
        String namespace = blockId.method_12836();
        String path = blockId.method_12832();
        class_2960 shortTex = class_2960.method_60655((String)namespace, (String)("block/" + path));
        class_2960 tallTex = class_2960.method_60655((String)namespace, (String)("block/" + path + "_tall"));
        class_4944 shortMap = new class_4944().method_25868(class_4945.field_23025, shortTex).method_25868(class_4945.field_23012, shortTex);
        class_4944 tallMap = new class_4944().method_25868(class_4945.field_23025, tallTex).method_25868(class_4945.field_23012, tallTex);
        class_2960 shortModel = class_4943.field_22921.method_25846(droopingBlock, shortMap, gen.field_22831);
        class_2960 tallModel = class_4943.field_22921.method_25847(droopingBlock, "_tall", tallMap, gen.field_22831);
        class_807 shortVariant = class_4910.method_67835((class_2960)shortModel);
        class_807 tallVariant = class_4910.method_67835((class_2960)tallModel);
        class_4926.class_4927 map = class_4926.method_67864((class_2769)DroopingLeavesBlock.EXTENDED);
        map.method_25794((Comparable)Boolean.valueOf(false), (Object)shortVariant);
        map.method_25794((Comparable)Boolean.valueOf(true), (Object)tallVariant);
        gen.field_22830.accept(class_4925.method_67852((class_2248)droopingBlock).method_67859((class_4926)map));
        gen.method_25623(droopingBlock, class_2960.method_60655((String)namespace, (String)("item/" + path)));
    }

    private static void registerSign(class_4910 gen, class_2248 standingSign, class_2248 wallSign) {
        class_2960 signTexture = class_2960.method_60655((String)class_7923.field_41175.method_10221((Object)standingSign).method_12836(), (String)("item/" + class_7923.field_41175.method_10221((Object)standingSign).method_12832()));
        class_4944 textures = class_4944.method_25883((class_4945)class_4945.field_23012, (class_2960)signTexture);
        class_807 variant = class_4910.method_67835((class_2960)class_4943.field_22908.method_25846(standingSign, textures, gen.field_22831));
        gen.field_22830.accept(class_4910.method_25644((class_2248)standingSign, (class_807)variant));
        gen.field_22830.accept(class_4910.method_25644((class_2248)wallSign, (class_807)variant));
        gen.method_25537(standingSign.method_8389());
    }
}

