/*
 * Decompiled with CFR 0.152.
 */
package com.kekie6.colorfulazaleas.registry;

import com.kekie6.colorfulazaleas.ColorfulAzaleas;
import com.kekie6.colorfulazaleas.block.ColorfulAzaleaBushBlock;
import com.kekie6.colorfulazaleas.block.DroopingLeavesBlock;
import com.kekie6.colorfulazaleas.util.AzaleaColors;
import com.kekie6.colorfulazaleas.util.AzaleaSignHelper;
import com.kekie6.colorfulazaleas.util.ColorfulTree;
import com.kekie6.colorfulazaleas.util.WoodSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.type.BlockSetTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.block.type.WoodTypeBuilder;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_10717;
import net.minecraft.class_11586;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2362;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2440;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2508;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2551;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8177;
import net.minecraft.class_8813;
import net.minecraft.class_9381;

public class AzaleaBlocks {
    public static ColorfulTree[] trees;
    private static final class_8177 BLOCK_SET_TYPE;
    private static final Map<String, class_4719> WOOD_TYPES;
    private static final class_4719 WOOD_TYPE;
    public static final List<class_2248> SHELF_BLOCKS;

    public static void init() {
        trees = (ColorfulTree[])Arrays.stream(AzaleaColors.values()).map(AzaleaBlocks::createTree).toArray(ColorfulTree[]::new);
    }

    private static ColorfulTree createTree(AzaleaColors color) {
        String title = color.getTitle();
        String name = color.name().toLowerCase(Locale.ROOT);
        ColorfulTree tree = new ColorfulTree(color);
        class_4719 woodType = AzaleaBlocks.getOrCreateWoodType(title);
        tree.setAzaleaLeaves(AzaleaBlocks.registerBlockWithItem(name + "_azalea_leaves", (class_2248)new class_10717(0.01f, (class_2394)class_9381.method_58256((class_2396)class_2398.field_55880, (int)color.getTint()), class_4970.class_2251.method_9630((class_4970)class_2246.field_28673).method_63500(AzaleaBlocks.blockKey(name + "_azalea_leaves")))));
        tree.setFloweringLeaves(AzaleaBlocks.registerBlockWithItem(name + "_flowering_azalea_leaves", (class_2248)new class_10717(0.01f, (class_2394)class_9381.method_58256((class_2396)class_2398.field_55880, (int)color.getTint()), class_4970.class_2251.method_9630((class_4970)class_2246.field_28673).method_63500(AzaleaBlocks.blockKey(name + "_flowering_azalea_leaves")))));
        tree.setBloomingLeaves(AzaleaBlocks.registerBlockWithItem(name + "_blooming_azalea_leaves", (class_2248)new class_10717(0.01f, (class_2394)class_9381.method_58256((class_2396)class_2398.field_55880, (int)color.getTint()), class_4970.class_2251.method_9630((class_4970)class_2246.field_28673).method_29292().method_63500(AzaleaBlocks.blockKey(name + "_blooming_azalea_leaves")))));
        tree.setDroopingLeaves(AzaleaBlocks.registerBlockWithItem(name + "_drooping_azalea_leaves", new DroopingLeavesBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_28673).method_9634().method_9626(class_2498.field_28692).method_63500(AzaleaBlocks.blockKey(name + "_drooping_azalea_leaves")))));
        class_5321 configuredFeatureKey = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)ColorfulAzaleas.id(name));
        class_8813 treeGrower = new class_8813("colorfulazaleas:" + name + "_azalea", Optional.empty(), Optional.of(configuredFeatureKey), Optional.empty());
        class_2248 sapling = AzaleaBlocks.registerBlockWithItem(name + "_azalea_sapling", (class_2248)new ColorfulAzaleaBushBlock(treeGrower, class_4970.class_2251.method_9630((class_4970)class_2246.field_28678).method_22488().method_63500(AzaleaBlocks.blockKey(name + "_azalea_sapling"))));
        tree.setSapling(sapling);
        tree.setPottedSapling(AzaleaBlocks.registerBlock("potted_" + name + "_azalea_sapling", (class_2248)new class_2362(sapling, class_2246.method_63176().method_63500(AzaleaBlocks.blockKey("potted_" + name + "_azalea_sapling")))));
        AzaleaBlocks.addBlockToAzaleaLootTable(sapling);
        CompostingChanceRegistry.INSTANCE.add((class_1935)sapling, (Object)Float.valueOf(0.65f));
        WoodSet woodSet = new WoodSet(title);
        woodSet.setLog(AzaleaBlocks.registerBlockWithItem(title + "_azalea_log", (class_2248)new class_2465(class_4970.class_2251.method_9630((class_4970)class_2246.field_10431).method_63500(AzaleaBlocks.blockKey(title + "_azalea_log")))));
        woodSet.setWood(AzaleaBlocks.registerBlockWithItem(title + "_azalea_wood", (class_2248)new class_2465(class_4970.class_2251.method_9630((class_4970)class_2246.field_10126).method_63500(AzaleaBlocks.blockKey(title + "_azalea_wood")))));
        woodSet.setStrippedLog(AzaleaBlocks.registerBlockWithItem("stripped_" + title + "_azalea_log", (class_2248)new class_2465(class_4970.class_2251.method_9630((class_4970)class_2246.field_10519).method_63500(AzaleaBlocks.blockKey("stripped_" + title + "_azalea_log")))));
        woodSet.setStrippedWood(AzaleaBlocks.registerBlockWithItem("stripped_" + title + "_azalea_wood", (class_2248)new class_2465(class_4970.class_2251.method_9630((class_4970)class_2246.field_10250).method_63500(AzaleaBlocks.blockKey("stripped_" + title + "_azalea_wood")))));
        woodSet.setPlanks(AzaleaBlocks.registerBlockWithItem(title + "_azalea_planks", new class_2248(class_4970.class_2251.method_9630((class_4970)class_2246.field_10161).method_63500(AzaleaBlocks.blockKey(title + "_azalea_planks")))));
        woodSet.setStairs(AzaleaBlocks.registerBlockWithItem(title + "_azalea_stairs", (class_2248)new class_2510(woodSet.getPlanks().method_9564(), class_4970.class_2251.method_9630((class_4970)class_2246.field_10563).method_63500(AzaleaBlocks.blockKey(title + "_azalea_stairs")))));
        woodSet.setSlab(AzaleaBlocks.registerBlockWithItem(title + "_azalea_slab", (class_2248)new class_2482(class_4970.class_2251.method_9630((class_4970)class_2246.field_10119).method_63500(AzaleaBlocks.blockKey(title + "_azalea_slab")))));
        woodSet.setFence(AzaleaBlocks.registerBlockWithItem(title + "_azalea_fence", (class_2248)new class_2354(class_4970.class_2251.method_9630((class_4970)class_2246.field_10620).method_63500(AzaleaBlocks.blockKey(title + "_azalea_fence")))));
        woodSet.setFenceGate(AzaleaBlocks.registerBlockWithItem(title + "_azalea_fence_gate", (class_2248)new class_2349(WOOD_TYPE, class_4970.class_2251.method_9630((class_4970)class_2246.field_10188).method_63500(AzaleaBlocks.blockKey(title + "_azalea_fence_gate")))));
        woodSet.setDoor(AzaleaBlocks.registerBlockWithItem(title + "_azalea_door", (class_2248)new class_2323(BLOCK_SET_TYPE, class_4970.class_2251.method_9630((class_4970)class_2246.field_10149).method_63500(AzaleaBlocks.blockKey(title + "_azalea_door")))));
        woodSet.setTrapdoor(AzaleaBlocks.registerBlockWithItem(title + "_azalea_trapdoor", (class_2248)new class_2533(BLOCK_SET_TYPE, class_4970.class_2251.method_9630((class_4970)class_2246.field_10137).method_63500(AzaleaBlocks.blockKey(title + "_azalea_trapdoor")))));
        woodSet.setPressurePlate(AzaleaBlocks.registerBlockWithItem(title + "_azalea_pressure_plate", (class_2248)new class_2440(BLOCK_SET_TYPE, class_4970.class_2251.method_9630((class_4970)class_2246.field_10484).method_63500(AzaleaBlocks.blockKey(title + "_azalea_pressure_plate")))));
        woodSet.setButton(AzaleaBlocks.registerBlockWithItem(title + "_azalea_button", (class_2248)new class_2269(BLOCK_SET_TYPE, 30, class_4970.class_2251.method_9630((class_4970)class_2246.field_10057).method_63500(AzaleaBlocks.blockKey(title + "_azalea_button")))));
        class_11586 shelf = new class_11586(class_4970.class_2251.method_9630((class_4970)class_2246.field_61371).method_63500(AzaleaBlocks.blockKey(title + "_azalea_shelf")));
        AzaleaBlocks.registerBlockWithItem(title + "_azalea_shelf", (class_2248)shelf);
        SHELF_BLOCKS.add((class_2248)shelf);
        woodSet.setShelf((class_2248)shelf);
        woodSet.setSign((class_2248)AzaleaSignHelper.registerSignBlock(ColorfulAzaleas.id(title + "_azalea_sign"), s -> new class_2508(woodType, s), AzaleaBlocks.blockSettings(title + "_azalea_sign", class_2246.field_10121)));
        woodSet.setWallSign((class_2248)AzaleaSignHelper.registerSignBlock(ColorfulAzaleas.id(title + "_azalea_wall_sign"), s -> new class_2551(woodType, s), AzaleaBlocks.blockSettings(title + "_azalea_wall_sign", class_2246.field_10187)));
        woodSet.setHangingSign((class_2248)AzaleaSignHelper.registerSignBlock(ColorfulAzaleas.id(title + "_azalea_hanging_sign"), s -> new class_7713(woodType, s), AzaleaBlocks.blockSettings(title + "_azalea_hanging_sign", class_2246.field_40262)));
        woodSet.setWallHangingSign((class_2248)AzaleaSignHelper.registerSignBlock(ColorfulAzaleas.id(title + "_azalea_wall_hanging_sign"), s -> new class_7715(woodType, s), AzaleaBlocks.blockSettings(title + "_azalea_wall_hanging_sign", class_2246.field_40272)));
        AzaleaSignHelper.registerSignItems(woodSet, title);
        StrippableBlockRegistry.register((class_2248)woodSet.getLog(), (class_2248)woodSet.getStrippedLog());
        StrippableBlockRegistry.register((class_2248)woodSet.getWood(), (class_2248)woodSet.getStrippedWood());
        tree.setWoodSet(woodSet);
        return tree;
    }

    public static void addBlockToAzaleaLootTable(class_2248 block) {
        LootTableEvents.MODIFY.register((key, builder, lootTableSource, provider) -> {
            if (((class_5321)class_2246.field_28673.method_26162().get()).equals(key)) {
                class_55.class_56 poolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_356(class_219.method_932((float)0.01f)).method_351((class_79.class_80)class_77.method_411((class_1935)block));
                builder.pool(poolBuilder.method_355());
            }
        });
    }

    public static class_5321<class_2248> blockKey(String name) {
        return class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)ColorfulAzaleas.id(name));
    }

    public static class_2248 registerBlockWithItem(String name, class_2248 block) {
        class_2960 id = ColorfulAzaleas.id(name);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)id, (Object)block);
        class_5321 itemKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)id);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, (Object)new class_1747(block, new class_1792.class_1793().method_63686(itemKey).method_63685()));
        return block;
    }

    public static class_2248 registerBlock(String name, class_2248 block) {
        class_2960 id = ColorfulAzaleas.id(name);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)id, (Object)block);
        return block;
    }

    private static class_4719 getOrCreateWoodType(String title) {
        if (WOOD_TYPES.containsKey(title = title.toLowerCase(Locale.ROOT))) {
            return WOOD_TYPES.get(title);
        }
        class_2960 id = ColorfulAzaleas.id(title + "_azalea");
        class_4719 woodType = new WoodTypeBuilder().register(id, BLOCK_SET_TYPE);
        WOOD_TYPES.put(title, woodType);
        return woodType;
    }

    private static class_4970.class_2251 blockSettings(String name, class_2248 base) {
        String baseName = name.replace("_wall_hanging_sign", "_hanging_sign").replace("_wall_sign", "_sign");
        class_5321<class_2248> blockKey = AzaleaBlocks.blockKey(name);
        class_2960 lootTableId = ColorfulAzaleas.id("blocks/" + baseName);
        class_5321 lootKey = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTableId);
        return class_4970.class_2251.method_9630((class_4970)base).method_63500(blockKey).method_63502(Optional.of(lootKey)).method_63501("block.colorfulazaleas." + name);
    }

    static {
        BLOCK_SET_TYPE = BlockSetTypeBuilder.copyOf((class_8177)class_8177.field_42826).register(ColorfulAzaleas.id("colorful_azaleas"));
        WOOD_TYPES = new HashMap<String, class_4719>();
        WOOD_TYPE = new WoodTypeBuilder().register(ColorfulAzaleas.id("colorful_azaleas"), BLOCK_SET_TYPE);
        SHELF_BLOCKS = new ArrayList<class_2248>();
    }
}

