/*
 * Decompiled with CFR 0.152.
 */
package com.kekie6.colorfulazaleas.decorators;

import com.kekie6.colorfulazaleas.ColorfulAzaleas;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Comparator;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_4651;
import net.minecraft.class_4662;
import net.minecraft.class_4663;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import org.jetbrains.annotations.NotNull;

public class ColorfulTreeDecorator
extends class_4662 {
    public static final MapCodec<ColorfulTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_4651.field_24937.fieldOf("top_leaf_block").forGetter(ColorfulTreeDecorator::getTopLeafBlock), (App)class_4651.field_24937.fieldOf("leaf_block").forGetter(ColorfulTreeDecorator::getLeafBlock), (App)class_4651.field_24937.fieldOf("hanging_block").forGetter(ColorfulTreeDecorator::getHangingBlock), (App)class_4651.field_24937.fieldOf("log_block").forGetter(ColorfulTreeDecorator::getLogBlock), (App)class_6017.field_29946.fieldOf("leaf_height").forGetter(ColorfulTreeDecorator::getLeafHeight), (App)class_6017.field_29946.fieldOf("hanging_height").forGetter(ColorfulTreeDecorator::getHangingHeight), (App)class_5699.field_34387.fieldOf("chance").forGetter(ColorfulTreeDecorator::getChance)).apply((Applicative)instance, ColorfulTreeDecorator::new));
    public final class_4651 topLeafBlock;
    public final class_4651 leafBlock;
    public final class_4651 hangingBlock;
    public final class_4651 logBlock;
    public final class_6017 leafHeight;
    public final class_6017 hangingHeight;
    public final float chance;

    public ColorfulTreeDecorator(class_4651 topLeafBlock, class_4651 leafBlock, class_4651 hangingBlock, class_4651 logBlock, class_6017 leafHeight, class_6017 hangingHeight, float chance) {
        this.topLeafBlock = topLeafBlock;
        this.leafBlock = leafBlock;
        this.hangingBlock = hangingBlock;
        this.logBlock = logBlock;
        this.leafHeight = leafHeight;
        this.hangingHeight = hangingHeight;
        this.chance = chance;
    }

    public class_4651 getTopLeafBlock() {
        return this.topLeafBlock;
    }

    public class_4651 getLeafBlock() {
        return this.leafBlock;
    }

    public class_4651 getHangingBlock() {
        return this.hangingBlock;
    }

    public class_4651 getLogBlock() {
        return this.logBlock;
    }

    public class_6017 getLeafHeight() {
        return this.leafHeight;
    }

    public class_6017 getHangingHeight() {
        return this.hangingHeight;
    }

    public float getChance() {
        return this.chance;
    }

    @NotNull
    protected class_4663<?> method_28893() {
        return ColorfulAzaleas.COLORFUL_TREE_DECORATOR;
    }

    public void method_23469(class_4662.class_7402 context) {
        class_5819 random = context.method_43320();
        ObjectArrayList logs = new ObjectArrayList((ObjectList)context.method_43321());
        logs.sort(Comparator.comparingInt(class_2382::method_10264).reversed());
        class_2338 bottomLog = (class_2338)logs.getFirst();
        for (class_2350 acceptablePos : class_2350.class_2353.field_11062) {
            class_2338 placementPosition;
            if (random.method_43057() >= 0.55f || !context.method_43317(placementPosition = bottomLog.method_10093(acceptablePos).method_10062())) continue;
            context.method_43318(placementPosition, this.getLogBlock().method_23455(context.method_43320(), placementPosition));
        }
        block1: for (class_2338 leaf : context.method_43322()) {
            boolean airBelow = context.method_43317(leaf.method_10074());
            if (airBelow) {
                context.method_43318(leaf, this.getTopLeafBlock().method_23455(random, leaf));
            }
            if (!airBelow || random.method_43057() >= this.chance) continue;
            int hangingCount = this.getHangingHeight().method_35008(random);
            for (int i = 1; i <= hangingCount; ++i) {
                class_2338 belowPos = leaf.method_10087(i);
                if (!context.method_43317(belowPos)) continue;
                context.method_43318(belowPos, this.getHangingBlock().method_23455(random, belowPos));
            }
            int leafCount = this.getLeafHeight().method_35008(random);
            for (int i = 0; i < leafCount; ++i) {
                boolean leafAbove = context.method_43322().contains((Object)leaf.method_10086(i + 1));
                class_4651 provider = i == leafCount - 1 || !leafAbove ? this.getTopLeafBlock() : this.getLeafBlock();
                class_2338 currLeafPos = leaf.method_10086(i);
                context.method_43318(currLeafPos, provider.method_23455(random, currLeafPos));
                if (!leafAbove) continue block1;
            }
        }
    }
}

