/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.command;

import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.util.Localizable;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public final class ModCommands {
    public static final LiteralArgumentBuilder<CommandSourceStack> ROOT = Commands.literal((String)"cucumber");

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)ROOT.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fillenergy").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"block").executes(context -> {
            ServerPlayer player;
            BlockHitResult trace;
            BlockPos pos;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.getLevel();
            IEnergyStorage energy = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, pos = (trace = BlockHelper.rayTraceBlocks((Level)level, (Player)(player = source.getPlayerOrException()))).getBlockPos(), (Object)trace.getDirection());
            if (energy != null) {
                if (energy.canReceive()) {
                    energy.receiveEnergy(Integer.MAX_VALUE, false);
                    MutableComponent message = Localizable.of("message.cucumber.filled_energy").args("block").build();
                    source.sendSuccess(() -> message, false);
                }
            } else {
                MutableComponent message = Localizable.of("message.cucumber.filled_energy_error").args("block").build();
                source.sendFailure((Component)message);
            }
            return 0;
        }))).then(Commands.literal((String)"hand").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayerOrException();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (!stack.isEmpty()) {
                IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (energy != null) {
                    if (energy.canReceive()) {
                        energy.receiveEnergy(Integer.MAX_VALUE, false);
                        MutableComponent message = Localizable.of("message.cucumber.filled_energy").args("item").build();
                        source.sendSuccess(() -> message, false);
                    }
                } else {
                    MutableComponent message = Localizable.of("message.cucumber.filled_energy_error").args("item").build();
                    source.sendFailure((Component)message);
                }
            } else {
                MutableComponent message = Localizable.of("message.cucumber.filled_energy_error").args("item").build();
                source.sendFailure((Component)message);
            }
            return 0;
        }))));
    }
}

