/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.client;

import com.bonker.stardewfishing.SFConfig;
import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.client.FishDisplayBER;
import com.bonker.stardewfishing.client.FishingScreen;
import com.bonker.stardewfishing.client.RodTooltipHandler;
import com.bonker.stardewfishing.client.SparkleParticle;
import com.bonker.stardewfishing.client.StardewFishingClient;
import com.bonker.stardewfishing.common.init.SFBlockEntities;
import com.bonker.stardewfishing.common.init.SFParticles;
import com.bonker.stardewfishing.common.init.SFSoundEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ClientEvents {

    @Mod.EventBusSubscriber(modid="stardew_fishing", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModBus {
        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)SFBlockEntities.FISH_DISPLAY.get(), FishDisplayBER::new);
        }

        @SubscribeEvent
        public static void onParticleRegistration(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)SFParticles.SPARKLE.get(), SparkleParticle.Provider::new);
        }

        @SubscribeEvent
        public static void onRegisterKeyBindings(RegisterKeyMappingsEvent event) {
            event.register(StardewFishingClient.MINIGAME_BUTTON.get());
        }
    }

    @Mod.EventBusSubscriber(modid="stardew_fishing", value={Dist.CLIENT})
    public static class ForgeBus {
        @SubscribeEvent
        public static void onRenderTooltip(RenderTooltipEvent.Pre event) {
            event.getGraphics().m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                RodTooltipHandler.tick(containerScreen.f_97734_, containerScreen.m_6262_().m_142621_());
            } else {
                RodTooltipHandler.clear();
            }
        }

        @SubscribeEvent
        public static void onScreenRendered(ContainerScreenEvent.Render.Foreground event) {
            if (SFConfig.isInventoryEquippingEnabled()) {
                RodTooltipHandler.render(event.getGuiGraphics(), Minecraft.m_91087_().getPartialTick(), event.getMouseX() - event.getContainerScreen().getGuiLeft(), event.getMouseY() - event.getContainerScreen().getGuiTop());
            }
        }

        @SubscribeEvent
        public static void onSoundPlayed(PlaySoundEvent event) {
            if (event.getSound() == null) {
                return;
            }
            try {
                SoundInstance instance = event.getSound();
                SoundEvent newEvent = null;
                if (instance instanceof SimpleSoundInstance && event.getSound().m_7904_().m_135827_().equals("minecraft")) {
                    switch (event.getSound().m_7904_().m_135815_()) {
                        case "entity.fishing_bobber.throw": {
                            newEvent = (SoundEvent)SFSoundEvents.CAST.get();
                            break;
                        }
                        case "entity.fishing_bobber.retrieve": {
                            if (Minecraft.m_91087_().f_91073_ == null) break;
                            Player player = Minecraft.m_91087_().f_91073_.m_45924_(event.getSound().m_7772_(), event.getSound().m_7780_(), event.getSound().m_7778_(), 1.0, false);
                            newEvent = player == null || player.f_36083_ == null ? (SoundEvent)SFSoundEvents.PULL_ITEM.get() : (SoundEvent)SFSoundEvents.FISH_HIT.get();
                            break;
                        }
                        case "entity.fishing_bobber.splash": {
                            newEvent = (SoundEvent)SFSoundEvents.FISH_BITE.get();
                        }
                    }
                }
                if (newEvent != null) {
                    event.setSound((SoundInstance)new SimpleSoundInstance(newEvent, SoundSource.MASTER, 1.0f, 1.0f, SoundInstance.m_235150_(), instance.m_7772_(), instance.m_7780_(), instance.m_7778_()));
                } else if (SFConfig.isolateAudioCues() && !event.getSound().m_7904_().m_135827_().equals("stardew_fishing") && Minecraft.m_91087_().f_91080_ instanceof FishingScreen) {
                    event.setSound(null);
                }
            }
            catch (Exception e) {
                StardewFishing.LOGGER.error("An exception occurred while trying to replace a sound event.", (Throwable)e);
            }
        }
    }
}

