/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.client;

import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.common.blocks.FishDisplayBlockEntity;
import com.bonker.stardewfishing.proxy.ItemUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class FishDisplayBER
implements BlockEntityRenderer<FishDisplayBlockEntity> {
    private final ItemRenderer itemRenderer;

    public FishDisplayBER(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public void render(FishDisplayBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        HitResult hitResult;
        float rot;
        ItemStack stack = pBlockEntity.getItem();
        if (stack.m_41619_() || pBlockEntity.m_58904_() == null) {
            return;
        }
        BlockPos pos = pBlockEntity.m_58899_();
        BlockState state = pBlockEntity.m_58904_().m_8055_(pos);
        if (!state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        boolean legendary = ItemUtils.isLegendaryFish(stack);
        pPoseStack.m_85836_();
        double offset = -0.421875;
        pPoseStack.m_85837_(0.5 + (double)facing.m_122429_() * offset, 0.5, 0.5 + (double)facing.m_122431_() * offset);
        switch (facing) {
            case SOUTH: {
                float f = 180.0f;
                break;
            }
            case WEST: {
                float f = 90.0f;
                break;
            }
            case EAST: {
                float f = -90.0f;
                break;
            }
            default: {
                float f = rot = 0.0f;
            }
        }
        if (rot != 0.0f) {
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(rot));
        }
        if ((hitResult = Minecraft.m_91087_().f_91077_) != null && hitResult.m_6662_() == HitResult.Type.BLOCK && ((BlockHitResult)hitResult).m_82425_().equals((Object)pos)) {
            MutableComponent component = Component.m_237119_().m_7220_(stack.m_41786_());
            if (stack.m_41788_()) {
                component.m_130940_(ChatFormatting.ITALIC);
            }
            if (legendary) {
                component.m_130948_(StardewFishing.LEGENDARY);
            }
            pPoseStack.m_85836_();
            pPoseStack.m_252880_(0.0f, -0.25f, -0.25f);
            pPoseStack.m_85841_(-0.025f, -0.025f, 0.025f);
            float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int bg = (int)(opacity * 255.0f) << 24;
            Font font = Minecraft.m_91087_().f_91062_;
            font.m_272077_((Component)component, (float)(-font.m_92852_((FormattedText)component)) / 2.0f, 0.0f, -1, false, pPoseStack.m_85850_().m_252922_(), pBuffer, Font.DisplayMode.NORMAL, 0, pPackedLight);
            font.m_272077_((Component)component, (float)(-font.m_92852_((FormattedText)component)) / 2.0f, 0.0f, 0x20FFFFFF, false, pPoseStack.m_85850_().m_252922_(), pBuffer, Font.DisplayMode.SEE_THROUGH, bg, pPackedLight);
            pPoseStack.m_85849_();
        }
        float scale = legendary ? 1.19f : 0.8f;
        pPoseStack.m_85841_(scale, scale, scale);
        int sum = pos.m_123341_() + pos.m_123342_() + pos.m_123343_();
        if (sum % 2 == 0) {
            pPoseStack.m_252880_(0.0f, 0.0f, -0.0078125f);
        }
        this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBuffer, pBlockEntity.m_58904_(), 0);
        pPoseStack.m_85849_();
    }
}

