/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.common.blocks;

import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.common.blocks.FishDisplayBlockEntity;
import com.bonker.stardewfishing.common.init.SFParticles;
import com.bonker.stardewfishing.proxy.ItemUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FishDisplayBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_NORTH = FishDisplayBlock.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = FishDisplayBlock.m_49796_((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = FishDisplayBlock.m_49796_((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = FishDisplayBlock.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)1.0);
    private static final Component TOOLTIP = Component.m_237115_((String)"item.stardew_fishing.fish_display.tooltip").m_130948_(StardewFishing.LIGHTER_COLOR);

    public FishDisplayBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean canBeDisplayed(ItemStack stack) {
        return stack.m_204117_(StardewFishing.IN_FISH_DISPLAY);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof FishDisplayBlockEntity) {
            FishDisplayBlockEntity fishDisplay = (FishDisplayBlockEntity)blockEntity;
            ItemStack displayed = fishDisplay.getItem();
            if (displayed.m_41619_()) {
                if (FishDisplayBlock.canBeDisplayed(stack) && !displayed.m_150930_(stack.m_41720_())) {
                    fishDisplay.setItem(stack.m_255036_(1));
                    if (!pPlayer.m_150110_().f_35937_ || stack.m_41782_()) {
                        stack.m_41774_(1);
                    }
                    pLevel.m_5594_(pPlayer, pPos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    pPlayer.m_6674_(pHand);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (!pPlayer.m_150110_().f_35937_ || displayed.m_41782_()) {
                    System.out.println(displayed.m_41784_());
                    pLevel.m_7967_((Entity)new ItemEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, displayed));
                }
                fishDisplay.setItem(ItemStack.f_41583_);
                pLevel.m_5594_(pPlayer, pPos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
                pPlayer.m_6674_(pHand);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        FishDisplayBlockEntity fishDisplay;
        ItemStack stack;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof FishDisplayBlockEntity && ItemUtils.isLegendaryFish(stack = (fishDisplay = (FishDisplayBlockEntity)blockEntity).getItem()) && pLevel.f_46441_.m_188501_() < 0.25f) {
            Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
            Vector3f spawnPos = new Vector3f((float)pPos.m_123341_() + 0.5f - (float)facing.m_122429_() * 0.3f, (float)pPos.m_123342_(), (float)pPos.m_123343_() + 0.5f - (float)facing.m_122431_() * 0.3f);
            if (facing.m_122434_() == Direction.Axis.X) {
                spawnPos.z += pLevel.f_46441_.m_188501_() - 0.5f;
            } else {
                spawnPos.x += pLevel.f_46441_.m_188501_() - 0.5f;
            }
            spawnPos.y += pLevel.f_46441_.m_188501_();
            pLevel.m_7106_((ParticleOptions)SFParticles.SPARKLE.get(), (double)spawnPos.x, (double)spawnPos.y, (double)spawnPos.z, 0.0, 0.0, 0.0);
        }
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add(TOOLTIP);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof FishDisplayBlockEntity) {
                FishDisplayBlockEntity fishDisplay = (FishDisplayBlockEntity)blockEntity;
                Containers.m_18992_((Level)pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (ItemStack)fishDisplay.getItem());
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> SHAPE_WEST;
            case Direction.SOUTH -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_SOUTH;
            default -> SHAPE_NORTH;
        };
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction facing = pContext.m_43719_();
        if (pContext.m_7078_() || facing.m_122434_() == Direction.Axis.Y) {
            facing = pContext.m_8125_().m_122424_();
        }
        Fluid fluid = pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, WATERLOGGED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new FishDisplayBlockEntity(pPos, pState);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        FishDisplayBlockEntity fishDisplay;
        ItemStack stack;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FishDisplayBlockEntity && !(stack = (fishDisplay = (FishDisplayBlockEntity)blockEntity).getItem()).m_41619_()) {
            return stack.m_255036_(1);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }
}

