/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.mixin;

import com.bonker.stardewfishing.SFConfig;
import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.common.FishingHookLogic;
import com.bonker.stardewfishing.common.init.SFSoundEvents;
import com.bonker.stardewfishing.mixin.FishingHookAccessor;
import com.llamalad7.mixinextras.sugar.Local;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import com.teammetallurgy.aquaculture.item.AquaFishingRodItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets={"com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity"})
public abstract class AquaFishingBobberEntityMixin
extends FishingHook
implements FishingHookAccessor {
    @Shadow
    protected abstract List<ItemStack> getLoot(LootParams var1, ServerLevel var2);

    @Accessor
    protected abstract ItemStack getFishingRod();

    private AquaFishingBobberEntityMixin(EntityType<? extends FishingHook> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"catchingFish(Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancel_catchingFish(BlockPos pPos, CallbackInfo ci) {
        if (this.getNibble() <= 0 && this.getTimeUntilHooked() <= 0 && this.getTimeUntilLured() <= 0) {
            int time = Mth.m_216271_((RandomSource)this.f_19796_, (int)100, (int)600);
            time -= this.getLureSpeed() * 20 * 5;
            time = Math.max(10, (int)((double)time * SFConfig.getBiteTimeMultiplier()));
            this.setTimeUntilLured(time);
        }
        if (FishingHookLogic.getStoredRewards(this).map(list -> !list.isEmpty()).orElse(false).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"retrieve(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/eventbus/api/IEventBus;post(Lnet/minecraftforge/eventbus/api/Event;)Z", ordinal=0)}, cancellable=true)
    public void retrieve(ItemStack pStack, CallbackInfoReturnable<Integer> cir, @Local List<ItemStack> items, @Local LootParams lootParams, @Local ServerLevel serverLevel) {
        AquaFishingBobberEntity hook = (AquaFishingBobberEntity)this;
        ServerPlayer player = (ServerPlayer)hook.m_37168_();
        if (player == null) {
            return;
        }
        if (items.stream().anyMatch(stack -> stack.m_204117_(StardewFishing.STARTS_MINIGAME))) {
            ItemStackHandler rodHandler;
            ItemStack bait;
            List<ItemStack> doubleLoot;
            FishingHookLogic.getStoredRewards((FishingHook)hook).ifPresent(rewards -> rewards.addAll(items));
            if (hook.hasHook() && hook.getHook().getDoubleCatchChance() > 0.0 && this.f_19796_.m_188500_() <= hook.getHook().getDoubleCatchChance() && !(doubleLoot = this.getLoot(lootParams, serverLevel)).isEmpty()) {
                MinecraftForge.EVENT_BUS.post((Event)new ItemFishedEvent(doubleLoot, 0, (FishingHook)this));
                FishingHookLogic.getStoredRewards((FishingHook)hook).ifPresent(rewards -> rewards.addAll(doubleLoot));
                this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
            }
            if (!player.m_7500_() && !(bait = (rodHandler = AquaFishingRodItem.getHandler((ItemStack)this.getFishingRod())).getStackInSlot(1)).m_41619_()) {
                if (bait.m_220157_(1, hook.m_9236_().f_46441_, null)) {
                    bait.m_41774_(1);
                    this.m_5496_((SoundEvent)AquaSounds.BOBBER_BAIT_BREAK.get(), 0.7f, 0.2f);
                }
                rodHandler.setStackInSlot(1, bait);
            }
            if (FishingHookLogic.startStardewMinigame(player)) {
                cir.cancel();
            }
        } else {
            FishingHookLogic.modifyRewards(items, 0.0, 0);
            player.m_9236_().m_6269_(null, (Entity)player, (SoundEvent)SFSoundEvents.PULL_ITEM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

