/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.server.data;

import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.common.FishBehavior;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class FishBehaviorReloadListener
extends SimplePreparableReloadListener<Map<String, JsonObject>> {
    private static final Gson GSON_INSTANCE = new Gson();
    private static final ResourceLocation LOCATION = StardewFishing.resource("fish_behaviors.json");
    private static final ResourceLocation OLD_LOCATION = StardewFishing.resource("data.json");
    private static FishBehaviorReloadListener INSTANCE;
    private final Map<Item, FishBehavior> fishBehaviors = new HashMap<Item, FishBehavior>();
    private final List<ResourceLocation> keys = new ArrayList<ResourceLocation>();
    private FishBehavior defaultBehavior;

    protected Map<String, JsonObject> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        BufferedReader reader;
        InputStream inputstream;
        HashMap<String, JsonObject> objects = new HashMap<String, JsonObject>();
        for (Resource resource : pResourceManager.m_213829_(LOCATION)) {
            try {
                inputstream = resource.m_215507_();
                try {
                    reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                    try {
                        objects.put(resource.m_215506_(), (JsonObject)GsonHelper.m_13776_((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class));
                    }
                    finally {
                        ((Reader)reader).close();
                    }
                }
                finally {
                    if (inputstream == null) continue;
                    inputstream.close();
                }
            }
            catch (IOException | RuntimeException exception) {
                StardewFishing.LOGGER.error("Invalid json in fish behavior list {} in data pack {}", new Object[]{LOCATION, resource.m_215506_(), exception});
            }
        }
        for (Resource resource : pResourceManager.m_213829_(OLD_LOCATION)) {
            try {
                inputstream = resource.m_215507_();
                try {
                    reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                    try {
                        StardewFishing.LOGGER.error("Error in datapack {}: Fish behavior list found at stardew_fishing/data.json. As of 3.0, fish behavior has been moved to stardew_fishing/fish_behaviors.json. This file has been loaded, but it will not be in the future.", (Object)resource.m_215506_());
                        objects.put(resource.m_215506_(), (JsonObject)GsonHelper.m_13776_((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class));
                    }
                    finally {
                        ((Reader)reader).close();
                    }
                }
                finally {
                    if (inputstream == null) continue;
                    inputstream.close();
                }
            }
            catch (IOException | RuntimeException exception) {
                StardewFishing.LOGGER.error("Invalid json in fish behavior list {} in data pack {}", new Object[]{LOCATION, resource.m_215506_(), exception});
            }
        }
        return objects;
    }

    protected void apply(Map<String, JsonObject> jsonObjects, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        for (Map.Entry<String, JsonObject> entry : jsonObjects.entrySet()) {
            FishBehaviorList.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue())).resultOrPartial(errorMsg -> StardewFishing.LOGGER.warn(FishBehaviorReloadListener.makeError((String)entry.getKey(), errorMsg))).ifPresent(behaviorList -> behaviorList.behaviors.forEach((loc, fishBehavior) -> {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
                if (item == Items.f_41852_) {
                    if (ModList.get().isLoaded(loc.m_135827_())) {
                        throw new RuntimeException(FishBehaviorReloadListener.makeError((String)entry.getKey(), "Mod '" + loc.m_135827_() + "' present but item not registered: " + loc.m_135815_()));
                    }
                } else {
                    if (behaviorList.replace || !this.fishBehaviors.containsKey(item)) {
                        this.fishBehaviors.put(item, (FishBehavior)fishBehavior);
                        this.keys.add((ResourceLocation)loc);
                    }
                    if (behaviorList.replace || this.defaultBehavior == null) {
                        behaviorList.defaultBehavior.ifPresent(behavior -> {
                            this.defaultBehavior = behavior;
                        });
                    }
                }
            }));
        }
        Collections.sort(this.keys);
    }

    private static String makeError(String datapackID, String description) {
        return "Failed to decode fish behavior list " + LOCATION + " in data pack " + datapackID + " - " + description;
    }

    public static FishBehaviorReloadListener create() {
        INSTANCE = new FishBehaviorReloadListener();
        return INSTANCE;
    }

    public static FishBehavior getBehavior(@Nullable ItemStack stack) {
        if (stack == null) {
            return FishBehaviorReloadListener.INSTANCE.defaultBehavior;
        }
        return FishBehaviorReloadListener.INSTANCE.fishBehaviors.getOrDefault(stack.m_41720_(), FishBehaviorReloadListener.INSTANCE.defaultBehavior);
    }

    public static List<ResourceLocation> getKeys() {
        return FishBehaviorReloadListener.INSTANCE.keys;
    }

    private record FishBehaviorList(boolean replace, Map<ResourceLocation, FishBehavior> behaviors, Optional<FishBehavior> defaultBehavior) {
        private static final Codec<FishBehaviorList> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(FishBehaviorList::replace), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, FishBehavior.CODEC).fieldOf("behaviors").forGetter(FishBehaviorList::behaviors), (App)FishBehavior.CODEC.optionalFieldOf("defaultBehavior").forGetter(FishBehaviorList::defaultBehavior)).apply((Applicative)inst, FishBehaviorList::new));
    }
}

