/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.server.data;

import com.bonker.stardewfishing.SFConfig;
import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.common.init.SFItems;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class LegendaryFishModifier
implements IGlobalLootModifier {
    public static final Codec<LegendaryFishModifier> CODEC = Codec.unit(LegendaryFishModifier::new);
    private static final List<ResourceLocation> FISHING_LOOT_TABLES = List.of(BuiltInLootTables.f_78720_, ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"gameplay/fishing/fish"), ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"gameplay/fishing/lava/fish"), ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"gameplay/fishing/nether/fish"), ResourceLocation.fromNamespaceAndPath((String)"tide", (String)"gameplay/fishing/climates/"), ResourceLocation.fromNamespaceAndPath((String)"tide", (String)"gameplay/fishing/special/"), ResourceLocation.fromNamespaceAndPath((String)"tide", (String)"gameplay/fishing/special"));
    private static final List<Vector2i> BIOME_CHECK_OFFSETS = List.of(new Vector2i(16, 0), new Vector2i(-16, 0), new Vector2i(0, 16), new Vector2i(0, -16), new Vector2i(16, 16), new Vector2i(16, -16), new Vector2i(-16, -16), new Vector2i(-16, 16), new Vector2i(32, 0), new Vector2i(-32, 0), new Vector2i(0, 32), new Vector2i(0, -32), new Vector2i(32, 32), new Vector2i(32, -32), new Vector2i(-32, -32), new Vector2i(-32, 32));

    @NotNull
    public ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockPos pos;
        ItemStack stack;
        if (generatedLoot.isEmpty()) {
            return generatedLoot;
        }
        if (context.m_230907_().m_188501_() >= SFConfig.getLegendaryFishChance(context.m_78945_())) {
            return generatedLoot;
        }
        if (LootContextParamSets.f_81414_.m_81394_().stream().anyMatch(param -> !context.m_78936_(param))) {
            return generatedLoot;
        }
        int index = 0;
        ObjectListIterator objectListIterator = generatedLoot.iterator();
        while (objectListIterator.hasNext() && !(stack = (ItemStack)objectListIterator.next()).m_204117_(ItemTags.f_13156_)) {
            ++index;
        }
        if (index == generatedLoot.size()) {
            return generatedLoot;
        }
        ResourceLocation lootId = context.getQueriedLootTableId();
        if (FISHING_LOOT_TABLES.stream().noneMatch(id -> lootId.m_135827_().equals(id.m_135827_()) && lootId.m_135815_().startsWith(id.m_135815_()))) {
            return generatedLoot;
        }
        ServerLevel level = context.m_78952_();
        LegendaryCategory category = this.findLegendaryCategory((Level)level, pos = BlockPos.m_274446_((Position)((Position)context.m_165124_(LootContextParams.f_81460_))));
        if (category != null) {
            generatedLoot.set(index, (Object)new ItemStack((ItemLike)category.chooseFish((Level)level)));
        }
        return generatedLoot;
    }

    @Nullable
    private LegendaryCategory findLegendaryCategory(Level level, BlockPos pos) {
        LegendaryCategory direct = null;
        Holder biome = level.m_204166_(pos);
        if (LegendaryCategory.JUNGLE.matches((Holder<Biome>)biome)) {
            return LegendaryCategory.JUNGLE;
        }
        if (LegendaryCategory.ARID.matches((Holder<Biome>)biome)) {
            return LegendaryCategory.ARID;
        }
        if (LegendaryCategory.WARM_OCEAN.matches((Holder<Biome>)biome)) {
            direct = LegendaryCategory.WARM_OCEAN;
        } else if (LegendaryCategory.NORMAL_OCEAN.matches((Holder<Biome>)biome)) {
            direct = LegendaryCategory.NORMAL_OCEAN;
        } else if (LegendaryCategory.RIVER.matches((Holder<Biome>)biome)) {
            direct = LegendaryCategory.RIVER;
        }
        for (Vector2i offset : BIOME_CHECK_OFFSETS) {
            biome = level.m_204166_(pos.m_7918_(offset.x, 0, offset.y));
            if (LegendaryCategory.JUNGLE.matches((Holder<Biome>)biome)) {
                return LegendaryCategory.JUNGLE;
            }
            if (!LegendaryCategory.ARID.matches((Holder<Biome>)biome)) continue;
            return LegendaryCategory.ARID;
        }
        return direct;
    }

    public Codec<LegendaryFishModifier> codec() {
        return CODEC;
    }

    public static enum LegendaryCategory {
        JUNGLE(StardewFishing.HAS_JUNGLE_FISH),
        ARID(StardewFishing.HAS_ARID_FISH),
        NORMAL_OCEAN(StardewFishing.HAS_NORMAL_OCEAN_FISH),
        WARM_OCEAN(StardewFishing.HAS_WARM_OCEAN_FISH),
        RIVER(StardewFishing.HAS_RIVER_FISH);

        private final TagKey<Biome> tag;

        private LegendaryCategory(TagKey<Biome> tag) {
            this.tag = tag;
        }

        public boolean matches(Holder<Biome> biome) {
            return biome.m_203656_(this.tag);
        }

        public Item chooseFish(Level level) {
            boolean rand = level.f_46441_.m_188499_();
            return (Item)(switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORMAL_OCEAN -> {
                    if (rand) {
                        yield SFItems.STORM_TARPON;
                    }
                    yield SFItems.GOLIATH_GROUPER;
                }
                case WARM_OCEAN -> {
                    if (rand) {
                        yield SFItems.BLAZING_OARFISH;
                    }
                    yield SFItems.CYCLOPS_MAHIMAHI;
                }
                case RIVER -> {
                    if (rand) {
                        yield SFItems.DEMON_GAR;
                    }
                    yield SFItems.CRYSTALLINE_SNAKEHEAD;
                }
                case JUNGLE -> {
                    if (rand) {
                        yield SFItems.CHROMATIC_ARAPAIMA;
                    }
                    yield SFItems.VAMPIRE_PAYARA;
                }
                case ARID -> rand ? SFItems.SABRETOOTHED_TIGERFISH : SFItems.GOLDEN_SNOOK;
            }).get();
        }
    }
}

