/*
 * Decompiled with CFR 0.152.
 */
package svar.ajneb97.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import svar.ajneb97.ServerVariables;
import svar.ajneb97.commands.subcommands.ListCommand;
import svar.ajneb97.managers.MessagesManager;
import svar.ajneb97.model.StringVariableResult;
import svar.ajneb97.model.internal.ValueFromArgumentResult;
import svar.ajneb97.model.structure.ValueType;
import svar.ajneb97.model.structure.Variable;
import svar.ajneb97.utils.OtherUtils;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    private ServerVariables plugin;
    private ListCommand listCommand;

    public MainCommand(ServerVariables plugin) {
        this.plugin = plugin;
        this.listCommand = new ListCommand(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("servervariables.admin")) {
            return false;
        }
        FileConfiguration config = this.plugin.getConfigsManager().getMainConfigManager().getConfig();
        MessagesManager msgManager = this.plugin.getMessagesManager();
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("set")) {
                this.set(sender, args, config, msgManager);
            } else if (args[0].equalsIgnoreCase("reload")) {
                this.reload(sender, args, config, msgManager);
            } else if (args[0].equalsIgnoreCase("get")) {
                this.get(sender, args, config, msgManager);
            } else if (args[0].equalsIgnoreCase("add")) {
                this.add(sender, args, config, msgManager);
            } else if (args[0].equalsIgnoreCase("reduce")) {
                this.reduce(sender, args, config, msgManager);
            } else if (args[0].equalsIgnoreCase("reset")) {
                this.reset(sender, args, config, msgManager);
            } else if (args[0].equalsIgnoreCase("list")) {
                this.list(sender, args, config, msgManager);
            } else {
                this.help(sender, args, config, msgManager);
            }
        } else {
            this.help(sender, args, config, msgManager);
        }
        return true;
    }

    public void help(CommandSender sender, String[] args, FileConfiguration config, MessagesManager msgManager) {
        sender.sendMessage(MessagesManager.getLegacyColoredMessage("&7[ [ &8[&aServerVariables&8] &7] ]"));
        sender.sendMessage(MessagesManager.getLegacyColoredMessage(" "));
        sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/svar help &8Shows this message."));
        sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/svar set <variable> <value> (optional)<player> (optional)silent:true &8Sets the value of a variable."));
        sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/svar get <variable> (optional)<player> (optional)silent:true &8Gets the value from a variable."));
        sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/svar add <variable> <value> (optional)<player> (optional)silent:true &8Adds a value to a variable (INTEGER or DOUBLE)."));
        sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/svar reduce <variable> <value> (optional)<player> (optional)silent:true &8Reduces the value of a variable (INTEGER or DOUBLE)."));
        sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/svar list <option> &8Manages a LIST type variable."));
        sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/svar reset <variable> <value> (optional)<player> (optional)silent:true &8Resets the value of a variable."));
        sender.sendMessage(MessagesManager.getLegacyColoredMessage("&6/svar reload &8Reloads the config."));
        sender.sendMessage(MessagesManager.getLegacyColoredMessage(" "));
        sender.sendMessage(MessagesManager.getLegacyColoredMessage("&7[ [ &8[&aServerVariables&8] &7] ]"));
    }

    public void set(CommandSender sender, String[] args, FileConfiguration config, MessagesManager msgManager) {
        if (args.length <= 2) {
            msgManager.sendMessage(sender, config.getString("messages.commandSetError"), true);
            return;
        }
        String variableName = args[1];
        ValueFromArgumentResult valueResult = OtherUtils.getValueFromArgument(args, 2);
        if (valueResult == null) {
            msgManager.sendMessage(sender, config.getString("messages.commandSetError"), true);
            return;
        }
        String newValue = valueResult.getFinalValue();
        int valueExtraArgs = valueResult.getExtraArgs();
        String playerName = null;
        if (args.length >= 4 + valueExtraArgs && !args[3 + valueExtraArgs].equals("silent:true")) {
            playerName = args[3 + valueExtraArgs];
        }
        StringVariableResult result = this.plugin.getVariablesManager().setVariableValue(playerName, variableName, newValue);
        boolean silent = args[args.length - 1].equals("silent:true");
        this.sendMessageSet(sender, result, msgManager, config, variableName, playerName, silent);
    }

    public void get(CommandSender sender, String[] args, FileConfiguration config, MessagesManager msgManager) {
        StringVariableResult result;
        if (args.length <= 1) {
            msgManager.sendMessage(sender, config.getString("messages.commandGetError"), true);
            return;
        }
        String variableName = args[1];
        String playerName = null;
        if (args.length >= 3) {
            playerName = args[2];
        }
        if ((result = this.plugin.getVariablesManager().getVariableValue(playerName, variableName, false)).isError()) {
            msgManager.sendMessage(sender, result.getErrorMessage(), true);
        } else if (playerName != null) {
            msgManager.sendMessage(sender, config.getString("messages.commandGetCorrectPlayer").replace("%variable%", variableName).replace("%value%", result.getResultValue()).replace("%player%", playerName), true);
        } else {
            msgManager.sendMessage(sender, config.getString("messages.commandGetCorrect").replace("%variable%", variableName).replace("%value%", result.getResultValue()), true);
        }
    }

    public void add(CommandSender sender, String[] args, FileConfiguration config, MessagesManager msgManager) {
        if (args.length <= 2) {
            msgManager.sendMessage(sender, config.getString("messages.commandAddError"), true);
            return;
        }
        String variableName = args[1];
        String value = args[2];
        String playerName = null;
        if (args.length >= 4 && !args[3].equals("silent:true")) {
            playerName = args[3];
        }
        StringVariableResult result = this.plugin.getVariablesManager().modifyVariable(playerName, variableName, value, true);
        boolean silent = args[args.length - 1].equals("silent:true");
        this.sendMessageSet(sender, result, msgManager, config, variableName, playerName, silent);
    }

    public void reduce(CommandSender sender, String[] args, FileConfiguration config, MessagesManager msgManager) {
        if (args.length <= 2) {
            msgManager.sendMessage(sender, config.getString("messages.commandReduceError"), true);
            return;
        }
        String variableName = args[1];
        String value = args[2];
        String playerName = null;
        if (args.length >= 4 && !args[3].equals("silent:true")) {
            playerName = args[3];
        }
        StringVariableResult result = this.plugin.getVariablesManager().modifyVariable(playerName, variableName, value, false);
        boolean silent = args[args.length - 1].equals("silent:true");
        this.sendMessageSet(sender, result, msgManager, config, variableName, playerName, silent);
    }

    public void reset(CommandSender sender, String[] args, FileConfiguration config, MessagesManager msgManager) {
        StringVariableResult result;
        if (args.length <= 1) {
            msgManager.sendMessage(sender, config.getString("messages.commandResetError"), true);
            return;
        }
        String variableName = args[1];
        String playerName = null;
        if (args.length >= 3 && !args[2].equals("silent:true")) {
            playerName = args[2];
            result = this.plugin.getVariablesManager().resetVariable(playerName, variableName, playerName.equals("*"));
        } else {
            result = this.plugin.getVariablesManager().resetVariable(null, variableName, false);
        }
        boolean silent = args[args.length - 1].equals("silent:true");
        if (result.isError()) {
            msgManager.sendMessage(sender, result.getErrorMessage(), true);
        } else {
            if (silent) {
                return;
            }
            if (playerName != null) {
                if (playerName.equals("*")) {
                    msgManager.sendMessage(sender, config.getString("messages.commandResetCorrectAll").replace("%variable%", variableName), true);
                } else {
                    msgManager.sendMessage(sender, config.getString("messages.commandResetCorrectPlayer").replace("%variable%", variableName).replace("%player%", playerName), true);
                }
            } else {
                msgManager.sendMessage(sender, config.getString("messages.commandResetCorrect").replace("%variable%", variableName), true);
            }
        }
    }

    public void list(CommandSender sender, String[] args, FileConfiguration config, MessagesManager msgManager) {
        this.listCommand.command(sender, args, config, msgManager);
    }

    private void sendMessageSet(CommandSender sender, StringVariableResult result, MessagesManager msgManager, FileConfiguration config, String variableName, String playerName, boolean silent) {
        boolean silentCommandsHideErrors = this.plugin.getConfigsManager().getMainConfigManager().isSilentCommandsHideErrors();
        if (result.isError()) {
            if (silent && silentCommandsHideErrors) {
                return;
            }
            msgManager.sendMessage(sender, result.getErrorMessage(), true);
        } else {
            if (silent) {
                return;
            }
            if (playerName != null) {
                msgManager.sendMessage(sender, config.getString("messages.commandSetCorrectPlayer").replace("%variable%", variableName).replace("%value%", result.getResultValue()).replace("%player%", playerName), true);
            } else {
                msgManager.sendMessage(sender, config.getString("messages.commandSetCorrect").replace("%variable%", variableName).replace("%value%", result.getResultValue()), true);
            }
        }
    }

    public void reload(CommandSender sender, String[] args, FileConfiguration config, MessagesManager msgManager) {
        if (!this.plugin.getConfigsManager().reloadConfigs()) {
            sender.sendMessage(ServerVariables.prefix + MessagesManager.getLegacyColoredMessage("&cThere was an error reloading the config, check the console."));
            return;
        }
        msgManager.sendMessage(sender, config.getString("messages.pluginReloaded"), true);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("servervariables.admin")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("reload");
            commands.add("set");
            commands.add("get");
            commands.add("add");
            commands.add("reduce");
            commands.add("reset");
            commands.add("help");
            commands.add("list");
            for (String c : commands) {
                if (!args[0].isEmpty() && !c.startsWith(args[0].toLowerCase())) continue;
                completions.add(c);
            }
            return completions;
        }
        Map<String, Variable> variables = this.plugin.getVariablesManager().getVariables();
        if (args[0].equalsIgnoreCase("list")) {
            return this.listCommand.onTabComplete(sender, args, variables);
        }
        if ((args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("get") || args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("reduce") || args[0].equalsIgnoreCase("reset")) && args.length == 2) {
            String argVariable = args[1];
            for (Map.Entry<String, Variable> entry : variables.entrySet()) {
                Variable variable = entry.getValue();
                if (!argVariable.isEmpty() && !variable.getName().toLowerCase().startsWith(argVariable.toLowerCase()) || variable.getValueType().equals((Object)ValueType.LIST)) continue;
                completions.add(variable.getName());
            }
            return completions;
        }
        if (args[0].equalsIgnoreCase("set") && args.length == 3) {
            Variable variable = this.plugin.getVariablesManager().getVariable(args[1]);
            String argVariable = args[2];
            if (variable != null) {
                List<String> possibleRealValues = variable.getPossibleRealValues();
                for (String possibleValue : possibleRealValues) {
                    if (!argVariable.isEmpty() && !possibleValue.toLowerCase().startsWith(argVariable.toLowerCase())) continue;
                    completions.add(possibleValue);
                }
            }
            completions.add("<value>");
            return completions;
        }
        if ((args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("reduce")) && args.length == 3) {
            completions.add("<value>");
            return completions;
        }
        if (args[0].equalsIgnoreCase("reset") && args.length == 3) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!args[2].isEmpty() && !p.getName().startsWith(args[2].toLowerCase())) continue;
                completions.add(p.getName());
            }
            this.addAllWord(completions, args[2]);
            return completions;
        }
        return null;
    }

    private void addAllWord(List<String> completions, String arg) {
        if (arg.isEmpty() || "*".startsWith(arg.toLowerCase())) {
            completions.add("*");
        }
    }
}

