/*
 * Decompiled with CFR 0.152.
 */
package svar.ajneb97.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bukkit.configuration.file.FileConfiguration;
import svar.ajneb97.ServerVariables;
import svar.ajneb97.config.model.CommonConfig;
import svar.ajneb97.managers.MessagesManager;
import svar.ajneb97.tasks.DataSaveTask;

public class MainConfigManager {
    private ServerVariables plugin;
    private CommonConfig configFile;
    private boolean updateNotify;
    private boolean isMySQL;
    private boolean silentCommandsHideErrors;
    private boolean useMiniMessage;

    public MainConfigManager(ServerVariables plugin) {
        this.plugin = plugin;
        this.configFile = new CommonConfig("config.yml", plugin, null, false);
        this.configFile.registerConfig();
        this.checkMessagesUpdate();
    }

    public void configure() {
        FileConfiguration config = this.configFile.getConfig();
        this.plugin.setMessagesManager(new MessagesManager(config.getString("messages.prefix")));
        DataSaveTask dataSaveTask = this.plugin.getDataSaveTask();
        if (dataSaveTask != null) {
            dataSaveTask.end();
        }
        dataSaveTask = new DataSaveTask(this.plugin);
        dataSaveTask.start(config.getInt("config.data_save_time"));
        this.updateNotify = config.getBoolean("update_notify");
        this.isMySQL = config.getBoolean("config.mysql_database.enabled");
        this.silentCommandsHideErrors = config.getBoolean("config.silent_commands_hide_errors");
        this.useMiniMessage = config.getBoolean("config.use_minimessage");
    }

    public boolean reloadConfig() {
        if (!this.configFile.reloadConfig()) {
            return false;
        }
        this.configure();
        return true;
    }

    public CommonConfig getConfigFile() {
        return this.configFile;
    }

    public boolean isMySQL() {
        return this.isMySQL;
    }

    public boolean isUpdateNotify() {
        return this.updateNotify;
    }

    public FileConfiguration getConfig() {
        return this.configFile.getConfig();
    }

    public void saveConfig() {
        this.configFile.saveConfig();
    }

    public void checkMessagesUpdate() {
        Path pathConfig = Paths.get(this.configFile.getRoute(), new String[0]);
        try {
            String text = new String(Files.readAllBytes(pathConfig));
            FileConfiguration config = this.getConfig();
            if (!text.contains("use_minimessage:")) {
                config.set("config.use_minimessage", (Object)false);
                this.saveConfig();
            }
            if (!text.contains("commandListError:")) {
                config.set("messages.commandListError", (Object)"&cYou need to use: &7/svar list <option>");
                config.set("messages.commandListGetError", (Object)"&cYou need to use: &7/svar list get <variable> <index> (optional)<player>");
                config.set("messages.commandListSetError", (Object)"&cYou need to use: &7/svar list set <variable> <index> <value> (optional)<player> (optional)silent:true");
                config.set("messages.commandListAddError", (Object)"&cYou need to use: &7/svar list add <variable> <value> (optional)<player> (optional)silent:true");
                config.set("messages.commandListDisplayError", (Object)"&cYou need to use: &7/svar list display <variable> (optional)<player>");
                config.set("messages.commandListResetError", (Object)"&cYou need to use: &7/svar list reset <variable> (optional)<player>");
                config.set("messages.commandListRemoveIndexError", (Object)"&cYou need to use: &7/svar list removeindex <variable> <index> (optional)<player>");
                config.set("messages.commandListRemoveValueError", (Object)"&cYou need to use: &7/svar list removevalue <variable> <value> (optional)<player>");
                config.set("messages.commandListInvalidIndex", (Object)"&cYou need to use a valid index.");
                config.set("messages.variableNotList", (Object)"&cThat variable is not a list.");
                config.set("messages.variableIsList", (Object)"&cThat variable is a list. Use &7/svar list <option>");
                config.set("messages.variableListIndexError", (Object)"&cThat list doesn't have the index &7%index%&c.");
                config.set("messages.variableListValueError", (Object)"&cThat list doesn't have the value &7%value%&c.");
                config.set("messages.commandListGetCorrect", (Object)"&aVariable &7%variable% &acurrent value at index &7%index% &ais: &7%value%&a.");
                config.set("messages.commandListGetCorrectPlayer", (Object)"&aVariable &7%variable% &acurrent value at index &7%index% &afrom player &e%player% &ais: &7%value%&a.");
                config.set("messages.commandListSetCorrect", (Object)"&aVariable &7%variable% &avalue at index &7%index% &aset to &7%value%&a.");
                config.set("messages.commandListSetCorrectPlayer", (Object)"&aVariable &7%variable% &avalue at index &7%index% &aset to &7%value% &afor player &e%player%&a.");
                config.set("messages.commandListDisplayCorrect", (Object)"&aVariable &7%variable% &acurrent values: &7%values%");
                config.set("messages.commandListDisplayCorrectPlayer", (Object)"&aVariable &7%variable% &acurrent values from player &e%player%&a: &7%values%");
                config.set("messages.commandListRemoveIndexCorrect", (Object)"&aVariable &7%variable% &avalue at index &7%index% &aremoved.");
                config.set("messages.commandListRemoveIndexCorrectPlayer", (Object)"&aVariable &7%variable% &avalue at index &7%index% &aremoved for player &e%player%&a.");
                config.set("messages.commandListRemoveValueCorrect", (Object)"&aVariable &7%variable% &avalue &7%value% &aremoved.");
                config.set("messages.commandListRemoveValueCorrectPlayer", (Object)"&aVariable &7%variable% &avalue &7%value% &aremoved for player &e%player%&a.");
                this.saveConfig();
            }
            if (!text.contains("update_notify:")) {
                this.getConfig().set("config.update_notify", (Object)true);
                this.saveConfig();
            }
            if (!text.contains("verifyServerCertificate:")) {
                this.getConfig().set("config.mysql_database.pool.connectionTimeout", (Object)5000);
                this.getConfig().set("config.mysql_database.advanced.verifyServerCertificate", (Object)false);
                this.getConfig().set("config.mysql_database.advanced.useSSL", (Object)true);
                this.getConfig().set("config.mysql_database.advanced.allowPublicKeyRetrieval", (Object)true);
                this.saveConfig();
            }
            if (!text.contains("silent_commands_hide_errors:")) {
                this.getConfig().set("config.silent_commands_hide_errors", (Object)false);
                this.saveConfig();
            }
            if (!text.contains("commandResetCorrectAll:")) {
                this.getConfig().set("messages.commandResetCorrectAll", (Object)"&aVariable &7%variable% &areset for &eall players&a.");
                this.saveConfig();
            }
            if (!text.contains("variableLimitationMaxCharactersError:")) {
                this.getConfig().set("messages.variableLimitationMaxCharactersError", (Object)"&cVariable supports a maximum of &7%value% &ccharacters.");
                this.saveConfig();
            }
            if (!text.contains("variableLimitationOutOfRangeMax:")) {
                this.getConfig().set("messages.variableLimitationOutOfRangeMax", (Object)"&cVariable out of range. Max value is &7%value%");
                this.getConfig().set("messages.variableLimitationOutOfRangeMin", (Object)"&cVariable out of range. Min value is &7%value%");
                this.saveConfig();
            }
            if (!text.contains("mysql_database:")) {
                this.getConfig().set("config.mysql_database.enabled", (Object)false);
                this.getConfig().set("config.mysql_database.host", (Object)"localhost");
                this.getConfig().set("config.mysql_database.port", (Object)3306);
                this.getConfig().set("config.mysql_database.username", (Object)"root");
                this.getConfig().set("config.mysql_database.password", (Object)"root");
                this.getConfig().set("config.mysql_database.database", (Object)"servervariables");
                this.saveConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isSilentCommandsHideErrors() {
        return this.silentCommandsHideErrors;
    }

    public boolean isUseMiniMessage() {
        return this.useMiniMessage;
    }
}

