/*
 * Decompiled with CFR 0.152.
 */
package svar.ajneb97.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import svar.ajneb97.ServerVariables;
import svar.ajneb97.api.ListVariableChangeEvent;
import svar.ajneb97.managers.ServerVariablesManager;
import svar.ajneb97.managers.VariablesManager;
import svar.ajneb97.model.ListVariableResult;
import svar.ajneb97.model.ServerVariablesListVariable;
import svar.ajneb97.model.ServerVariablesPlayer;
import svar.ajneb97.model.StringVariableResult;
import svar.ajneb97.model.structure.ListVariable;
import svar.ajneb97.model.structure.ValueType;
import svar.ajneb97.model.structure.Variable;
import svar.ajneb97.model.structure.VariableType;

public class ListVariablesManager {
    private ServerVariables plugin;

    public ListVariablesManager(ServerVariables plugin) {
        this.plugin = plugin;
    }

    public StringVariableResult getListVariableValueAtIndex(String playerName, String variableName, int index) {
        FileConfiguration config = this.plugin.getConfigsManager().getMainConfigManager().getConfig();
        ListVariableResult listVariableResult = this.getListVariableValue(playerName, variableName, false);
        if (listVariableResult.isError()) {
            return listVariableResult.toStringVariableResult();
        }
        List<String> variableValue = listVariableResult.getResultValue();
        if (index >= variableValue.size()) {
            return StringVariableResult.error(config.getString("messages.variableListIndexError").replace("%index%", index + ""), "variableListIndexError");
        }
        return StringVariableResult.noErrorsWithVariable(variableValue.get(index), listVariableResult.getVariable());
    }

    public StringVariableResult setListVariableValue(String playerName, String variableName, int index, String newValue, boolean add) {
        ListVariableResult listVariableResult;
        FileConfiguration config = this.plugin.getConfigsManager().getMainConfigManager().getConfig();
        VariablesManager variablesManager = this.plugin.getVariablesManager();
        StringVariableResult checkCommon = variablesManager.checkVariableCommon(variableName, newValue);
        if (checkCommon.isError()) {
            return checkCommon;
        }
        if (checkCommon.getResultValue() != null) {
            newValue = checkCommon.getResultValue();
        }
        if ((listVariableResult = this.getListVariableValue(playerName, variableName, true)).isError()) {
            return listVariableResult.toStringVariableResult();
        }
        List<String> variableValue = listVariableResult.getResultValue();
        Variable variable = listVariableResult.getVariable();
        ServerVariablesListVariable currentVariable = listVariableResult.getCurrentVariable();
        ServerVariablesPlayer serverVariablesPlayer = listVariableResult.getServerVariablesPlayer();
        ServerVariablesManager serverVariablesManager = this.plugin.getServerVariablesManager();
        ArrayList<String> oldValue = new ArrayList<String>(variableValue);
        if (!add) {
            if (index >= variableValue.size()) {
                return StringVariableResult.error(config.getString("messages.variableListIndexError").replace("%index%", index + ""), "variableListIndexError");
            }
            variableValue.set(index, newValue);
        } else {
            variableValue.add(newValue);
            index = variableValue.size() - 1;
        }
        Player player = playerName != null ? Bukkit.getPlayer((String)playerName) : null;
        this.updateVariableData(playerName, variableName, variableValue, currentVariable, serverVariablesPlayer, serverVariablesManager);
        this.plugin.getServer().getPluginManager().callEvent((Event)new ListVariableChangeEvent(player, variable, variableValue, oldValue, index));
        return StringVariableResult.noErrors(newValue).withIndex(index);
    }

    public ListVariableResult getListVariableValue(String playerName, String variableName, boolean modifying) {
        ServerVariablesListVariable currentVariable;
        FileConfiguration config = this.plugin.getConfigsManager().getMainConfigManager().getConfig();
        Variable aVariable = this.plugin.getVariablesManager().getVariable(variableName);
        if (aVariable == null) {
            return ListVariableResult.error(config.getString("messages.variableDoesNotExists"), "variableDoesNotExists");
        }
        if (!aVariable.getValueType().equals((Object)ValueType.LIST)) {
            return ListVariableResult.error(config.getString("messages.variableNotList"), "variableNotList");
        }
        ListVariable variable = (ListVariable)aVariable;
        ServerVariablesPlayer serverVariablesPlayer = null;
        if (playerName != null) {
            if (variable.getVariableType().equals((Object)VariableType.GLOBAL)) {
                if (modifying) {
                    return ListVariableResult.error(config.getString("messages.variableSetInvalidTypeGlobal"), "variableSetInvalidTypeGlobal");
                }
                return ListVariableResult.error(config.getString("messages.variableGetInvalidTypeGlobal"), "variableGetInvalidTypeGlobal");
            }
            serverVariablesPlayer = this.plugin.getPlayerVariablesManager().getPlayerByName(playerName);
            if (serverVariablesPlayer == null) {
                return ListVariableResult.error(config.getString("messages.playerNoData"), "playerNoData");
            }
            currentVariable = (ServerVariablesListVariable)serverVariablesPlayer.getCurrentVariable(variableName);
        } else {
            if (variable.getVariableType().equals((Object)VariableType.PLAYER)) {
                if (modifying) {
                    return ListVariableResult.error(config.getString("messages.variableSetInvalidTypePlayer"), "variableSetInvalidTypePlayer");
                }
                return ListVariableResult.error(config.getString("messages.variableGetInvalidTypePlayer"), "variableGetInvalidTypePlayer");
            }
            currentVariable = (ServerVariablesListVariable)this.plugin.getServerVariablesManager().getCurrentVariable(variableName);
        }
        ArrayList<String> variableValue = currentVariable == null ? new ArrayList<String>((Collection<String>)variable.getInitialValue()) : currentVariable.getCurrentValue();
        return ListVariableResult.noErrorsWithVariable(variableValue, variable).withCurrentVariable(currentVariable).withServerVariablesPlayer(serverVariablesPlayer);
    }

    public StringVariableResult removeListVariableIndex(String playerName, String variableName, int index) {
        FileConfiguration config = this.plugin.getConfigsManager().getMainConfigManager().getConfig();
        ListVariableResult listVariableResult = this.getListVariableValue(playerName, variableName, true);
        if (listVariableResult.isError()) {
            return listVariableResult.toStringVariableResult();
        }
        List<String> variableValue = listVariableResult.getResultValue();
        Variable variable = listVariableResult.getVariable();
        ServerVariablesListVariable currentVariable = listVariableResult.getCurrentVariable();
        ServerVariablesPlayer serverVariablesPlayer = listVariableResult.getServerVariablesPlayer();
        ServerVariablesManager serverVariablesManager = this.plugin.getServerVariablesManager();
        ArrayList<String> oldValue = new ArrayList<String>(variableValue);
        if (index >= variableValue.size()) {
            return StringVariableResult.error(config.getString("messages.variableListIndexError").replace("%index%", index + ""), "variableListIndexError");
        }
        variableValue.remove(index);
        Player player = playerName != null ? Bukkit.getPlayer((String)playerName) : null;
        this.updateVariableData(playerName, variableName, variableValue, currentVariable, serverVariablesPlayer, serverVariablesManager);
        this.plugin.getServer().getPluginManager().callEvent((Event)new ListVariableChangeEvent(player, variable, variableValue, oldValue, index));
        return StringVariableResult.noErrors(null).withIndex(index);
    }

    public StringVariableResult removeListVariableValue(String playerName, String variableName, String value) {
        FileConfiguration config = this.plugin.getConfigsManager().getMainConfigManager().getConfig();
        ListVariableResult listVariableResult = this.getListVariableValue(playerName, variableName, true);
        if (listVariableResult.isError()) {
            return listVariableResult.toStringVariableResult();
        }
        List<String> variableValue = listVariableResult.getResultValue();
        Variable variable = listVariableResult.getVariable();
        ServerVariablesListVariable currentVariable = listVariableResult.getCurrentVariable();
        ServerVariablesPlayer serverVariablesPlayer = listVariableResult.getServerVariablesPlayer();
        ServerVariablesManager serverVariablesManager = this.plugin.getServerVariablesManager();
        ArrayList<String> oldValue = new ArrayList<String>(variableValue);
        if (!variableValue.remove(value)) {
            return StringVariableResult.error(config.getString("messages.variableListValueError").replace("%value%", value), "variableListValueError");
        }
        Player player = playerName != null ? Bukkit.getPlayer((String)playerName) : null;
        this.updateVariableData(playerName, variableName, variableValue, currentVariable, serverVariablesPlayer, serverVariablesManager);
        this.plugin.getServer().getPluginManager().callEvent((Event)new ListVariableChangeEvent(player, variable, variableValue, oldValue, -1));
        return StringVariableResult.noErrors(null);
    }

    private void updateVariableData(String playerName, String variableName, List<String> variableValue, ServerVariablesListVariable currentVariable, ServerVariablesPlayer serverVariablesPlayer, ServerVariablesManager serverVariablesManager) {
        if (playerName != null) {
            if (this.plugin.getMySQLConnection() != null) {
                this.plugin.getMySQLConnection().updateVariable(serverVariablesPlayer, variableName, this.valueFromListToString(variableValue));
            }
            if (currentVariable == null) {
                serverVariablesPlayer.addVariable(new ServerVariablesListVariable(variableName, variableValue));
            } else {
                currentVariable.setCurrentValue(variableValue);
            }
            serverVariablesPlayer.setModified(true);
        } else if (currentVariable == null) {
            serverVariablesManager.addVariable(new ServerVariablesListVariable(variableName, variableValue));
        } else {
            currentVariable.setCurrentValue(variableValue);
        }
    }

    private String valueFromListToString(List<String> variableValue) {
        return String.join((CharSequence)"|", variableValue);
    }
}

