/*
 * Decompiled with CFR 0.152.
 */
package svar.ajneb97.managers;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import svar.ajneb97.ServerVariables;
import svar.ajneb97.api.ListVariableChangeEvent;
import svar.ajneb97.api.StringVariableChangeEvent;
import svar.ajneb97.managers.ListVariablesManager;
import svar.ajneb97.managers.ServerVariablesManager;
import svar.ajneb97.model.ServerVariablesListVariable;
import svar.ajneb97.model.ServerVariablesPlayer;
import svar.ajneb97.model.ServerVariablesStringVariable;
import svar.ajneb97.model.ServerVariablesVariable;
import svar.ajneb97.model.StringVariableResult;
import svar.ajneb97.model.structure.Limitations;
import svar.ajneb97.model.structure.ListVariable;
import svar.ajneb97.model.structure.StringVariable;
import svar.ajneb97.model.structure.ValueType;
import svar.ajneb97.model.structure.Variable;
import svar.ajneb97.model.structure.VariableType;
import svar.ajneb97.utils.MathUtils;

public class VariablesManager {
    private ServerVariables plugin;
    private ListVariablesManager listVariablesManager;
    private Map<String, Variable> variables;

    public VariablesManager(ServerVariables plugin) {
        this.plugin = plugin;
        this.listVariablesManager = new ListVariablesManager(plugin);
    }

    public Map<String, Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Variable> variables) {
        this.variables = variables;
    }

    public Variable getVariable(String name) {
        return this.variables.get(name);
    }

    public ListVariablesManager getListVariablesManager() {
        return this.listVariablesManager;
    }

    public StringVariableResult getVariableValue(String playerName, @NotNull String variableName, boolean modifying) {
        ServerVariablesStringVariable currentVariable;
        FileConfiguration config = this.plugin.getConfigsManager().getMainConfigManager().getConfig();
        Variable aVariable = this.plugin.getVariablesManager().getVariable(variableName);
        if (aVariable == null) {
            return StringVariableResult.error(config.getString("messages.variableDoesNotExists"), "variableDoesNotExists");
        }
        if (aVariable.getValueType().equals((Object)ValueType.LIST)) {
            return StringVariableResult.error(config.getString("messages.variableIsList"), "variableIsList");
        }
        if (playerName != null) {
            if (aVariable.getVariableType().equals((Object)VariableType.GLOBAL)) {
                if (modifying) {
                    return StringVariableResult.error(config.getString("messages.variableSetInvalidTypeGlobal"), "variableSetInvalidTypeGlobal");
                }
                return StringVariableResult.error(config.getString("messages.variableGetInvalidTypeGlobal"), "variableGetInvalidTypeGlobal");
            }
            ServerVariablesPlayer serverVariablesPlayer = this.plugin.getPlayerVariablesManager().getPlayerByName(playerName);
            if (serverVariablesPlayer == null) {
                return StringVariableResult.error(config.getString("messages.playerNoData"), "playerNoData");
            }
            currentVariable = (ServerVariablesStringVariable)serverVariablesPlayer.getCurrentVariable(variableName);
        } else {
            if (aVariable.getVariableType().equals((Object)VariableType.PLAYER)) {
                if (modifying) {
                    return StringVariableResult.error(config.getString("messages.variableSetInvalidTypePlayer"), "variableSetInvalidTypePlayer");
                }
                return StringVariableResult.error(config.getString("messages.variableGetInvalidTypePlayer"), "variableGetInvalidTypePlayer");
            }
            currentVariable = (ServerVariablesStringVariable)this.plugin.getServerVariablesManager().getCurrentVariable(variableName);
        }
        StringVariable variable = (StringVariable)aVariable;
        if (currentVariable == null) {
            return StringVariableResult.noErrorsWithVariable(variable.getInitialValue(), variable);
        }
        return StringVariableResult.noErrorsWithVariable(currentVariable.getCurrentValue(), variable);
    }

    public StringVariableResult setVariableValue(String playerName, @NotNull String variableName, @NotNull String newValue) {
        ServerVariablesStringVariable currentVariable;
        Variable aVariable;
        FileConfiguration config = this.plugin.getConfigsManager().getMainConfigManager().getConfig();
        VariablesManager variablesManager = this.plugin.getVariablesManager();
        StringVariableResult checkCommon = variablesManager.checkVariableCommon(variableName, newValue);
        if (checkCommon.isError()) {
            return checkCommon;
        }
        if (checkCommon.getResultValue() != null) {
            newValue = checkCommon.getResultValue();
        }
        if ((aVariable = checkCommon.getVariable()).getValueType().equals((Object)ValueType.LIST)) {
            return StringVariableResult.error(config.getString("messages.variableIsList"), "variableIsList");
        }
        ServerVariablesManager serverVariablesManager = this.plugin.getServerVariablesManager();
        StringVariable variable = (StringVariable)aVariable;
        ServerVariablesPlayer serverVariablesPlayer = null;
        if (playerName != null) {
            if (variable.getVariableType().equals((Object)VariableType.GLOBAL)) {
                return StringVariableResult.error(config.getString("messages.variableSetInvalidTypeGlobal"), "variableSetInvalidTypeGlobal");
            }
            serverVariablesPlayer = this.plugin.getPlayerVariablesManager().getPlayerByName(playerName);
            if (serverVariablesPlayer == null) {
                return StringVariableResult.error(config.getString("messages.playerNoData"), "playerNoData");
            }
            currentVariable = (ServerVariablesStringVariable)serverVariablesPlayer.getCurrentVariable(variableName);
        } else {
            if (variable.getVariableType().equals((Object)VariableType.PLAYER)) {
                return StringVariableResult.error(config.getString("messages.variableSetInvalidTypePlayer"), "variableSetInvalidTypePlayer");
            }
            currentVariable = (ServerVariablesStringVariable)serverVariablesManager.getCurrentVariable(variableName);
        }
        newValue = variablesManager.variableTransformations(variable, newValue);
        String oldValue = currentVariable == null ? variable.getInitialValue() : currentVariable.getCurrentValue();
        Player player = null;
        if (playerName != null) {
            if (this.plugin.getMySQLConnection() != null) {
                this.plugin.getMySQLConnection().updateVariable(serverVariablesPlayer, variableName, newValue);
            }
            if (currentVariable == null) {
                serverVariablesPlayer.addVariable(new ServerVariablesStringVariable(variableName, newValue));
            } else {
                currentVariable.setCurrentValue(newValue);
            }
            serverVariablesPlayer.setModified(true);
            player = Bukkit.getPlayer((String)serverVariablesPlayer.getName());
        } else if (currentVariable == null) {
            serverVariablesManager.addVariable(new ServerVariablesStringVariable(variableName, newValue));
        } else {
            currentVariable.setCurrentValue(newValue);
        }
        this.plugin.getServer().getPluginManager().callEvent((Event)new StringVariableChangeEvent(player, variable, newValue, oldValue));
        return StringVariableResult.noErrors(newValue);
    }

    public StringVariableResult modifyVariable(String playerName, String variableName, String value, boolean add) {
        FileConfiguration config = this.plugin.getConfigsManager().getMainConfigManager().getConfig();
        StringVariableResult result = playerName != null ? this.getVariableValue(playerName, variableName, true) : this.getVariableValue(null, variableName, true);
        if (result.isError()) {
            return StringVariableResult.error(result.getErrorMessage(), result.getErrorKey());
        }
        if (!MathUtils.isParsable(value)) {
            return StringVariableResult.error(config.getString("messages.invalidValue"), "invalidValue");
        }
        ValueType valueType = result.getVariable().getValueType();
        if (valueType == ValueType.TEXT) {
            return add ? StringVariableResult.error(config.getString("messages.variableAddError"), "variableAddError") : StringVariableResult.error(config.getString("messages.variableReduceError"), "variableReduceError");
        }
        try {
            double newValue = MathUtils.getDoubleSum(value, result.getResultValue(), add);
            if (value.contains(".") || valueType == ValueType.DOUBLE) {
                return this.setVariableValue(playerName, variableName, newValue + "");
            }
            return this.setVariableValue(playerName, variableName, (long)newValue + "");
        }
        catch (NumberFormatException e) {
            return add ? StringVariableResult.error(config.getString("messages.variableAddError"), "variableAddError") : StringVariableResult.error(config.getString("messages.variableReduceError"), "variableReduceError");
        }
    }

    public StringVariableResult resetVariable(String playerName, String variableName, boolean allPlayers) {
        FileConfiguration config = this.plugin.getConfigsManager().getMainConfigManager().getConfig();
        Variable aVariable = this.plugin.getVariablesManager().getVariable(variableName);
        if (aVariable == null) {
            return StringVariableResult.error(config.getString("messages.variableDoesNotExists"), "variableDoesNotExists");
        }
        if (playerName != null || allPlayers) {
            if (aVariable.getVariableType().equals((Object)VariableType.GLOBAL)) {
                return StringVariableResult.error(config.getString("messages.variableResetInvalidTypeGlobal"), "variableResetInvalidTypeGlobal");
            }
            ServerVariablesPlayer serverVariablesPlayer = null;
            if (!allPlayers && (serverVariablesPlayer = this.plugin.getPlayerVariablesManager().getPlayerByName(playerName)) == null) {
                return StringVariableResult.error(config.getString("messages.playerNoData"), "playerNoData");
            }
            if (this.plugin.getMySQLConnection() != null) {
                if (allPlayers) {
                    this.plugin.getMySQLConnection().resetVariable(null, variableName, true);
                } else {
                    this.plugin.getMySQLConnection().resetVariable(serverVariablesPlayer, variableName, false);
                }
            }
            if (allPlayers) {
                Map<UUID, ServerVariablesPlayer> playerVariables = this.plugin.getPlayerVariablesManager().getPlayerVariables();
                for (Map.Entry<UUID, ServerVariablesPlayer> entry : playerVariables.entrySet()) {
                    Variable variable;
                    ServerVariablesVariable removedF;
                    Player player;
                    ServerVariablesPlayer p = entry.getValue();
                    ServerVariablesVariable removed = p.resetVariable(variableName);
                    if (removed == null || p.getName() == null || (player = Bukkit.getPlayer((String)p.getName())) == null) continue;
                    if (aVariable.getValueType().equals((Object)ValueType.LIST)) {
                        removedF = (ServerVariablesListVariable)removed;
                        variable = (ListVariable)aVariable;
                        this.plugin.getServer().getPluginManager().callEvent((Event)new ListVariableChangeEvent(player, variable, (List<String>)((ListVariable)variable).getInitialValue(), (List<String>)((ServerVariablesListVariable)removedF).getCurrentValue(), -1));
                        continue;
                    }
                    removedF = (ServerVariablesStringVariable)removed;
                    variable = (StringVariable)aVariable;
                    this.plugin.getServer().getPluginManager().callEvent((Event)new StringVariableChangeEvent(player, variable, ((StringVariable)variable).getInitialValue(), ((ServerVariablesStringVariable)removedF).getCurrentValue()));
                }
            } else if (aVariable.getValueType().equals((Object)ValueType.LIST)) {
                ServerVariablesListVariable removed = (ServerVariablesListVariable)serverVariablesPlayer.resetVariable(variableName);
                if (removed != null) {
                    ListVariable variable = (ListVariable)aVariable;
                    this.plugin.getServer().getPluginManager().callEvent((Event)new ListVariableChangeEvent(Bukkit.getPlayer((String)playerName), variable, (List<String>)variable.getInitialValue(), (List<String>)removed.getCurrentValue(), -1));
                }
            } else {
                ServerVariablesStringVariable removed = (ServerVariablesStringVariable)serverVariablesPlayer.resetVariable(variableName);
                if (removed != null) {
                    StringVariable variable = (StringVariable)aVariable;
                    this.plugin.getServer().getPluginManager().callEvent((Event)new StringVariableChangeEvent(Bukkit.getPlayer((String)playerName), variable, variable.getInitialValue(), removed.getCurrentValue()));
                }
            }
        } else {
            if (aVariable.getVariableType().equals((Object)VariableType.PLAYER)) {
                return StringVariableResult.error(config.getString("messages.variableResetInvalidTypePlayer"), "variableResetInvalidTypePlayer");
            }
            if (aVariable.getValueType().equals((Object)ValueType.LIST)) {
                ServerVariablesListVariable removed = (ServerVariablesListVariable)this.plugin.getServerVariablesManager().getVariables().remove(variableName);
                if (removed != null) {
                    ListVariable variable = (ListVariable)aVariable;
                    this.plugin.getServer().getPluginManager().callEvent((Event)new ListVariableChangeEvent(null, variable, (List<String>)variable.getInitialValue(), (List<String>)removed.getCurrentValue(), -1));
                }
            } else {
                ServerVariablesStringVariable removed = (ServerVariablesStringVariable)this.plugin.getServerVariablesManager().getVariables().remove(variableName);
                if (removed != null) {
                    StringVariable variable = (StringVariable)aVariable;
                    this.plugin.getServer().getPluginManager().callEvent((Event)new StringVariableChangeEvent(null, variable, variable.getInitialValue(), removed.getCurrentValue()));
                }
            }
        }
        return StringVariableResult.noErrors(null);
    }

    public StringVariableResult checkVariableCommon(String variableName, String newValue) {
        FileConfiguration config = this.plugin.getConfigsManager().getMainConfigManager().getConfig();
        Variable variable = this.plugin.getVariablesManager().getVariable(variableName);
        if (variable == null) {
            return StringVariableResult.error(config.getString("messages.variableDoesNotExists"), "variableDoesNotExists");
        }
        ValueType type = variable.getValueType();
        if (!ValueType.isValid(type, newValue)) {
            return StringVariableResult.error(config.getString("messages.variableInvalidValue").replace("%value_type%", type.name()), "variableInvalidValue");
        }
        List<String> possibleRealValues = variable.getPossibleRealValues();
        if (!possibleRealValues.isEmpty()) {
            boolean isPossibleValue = false;
            String possibleValuesText = "";
            for (int i = 0; i < possibleRealValues.size(); ++i) {
                String possibleValue = possibleRealValues.get(i);
                if (possibleValue.equals(newValue)) {
                    isPossibleValue = true;
                    break;
                }
                possibleValuesText = i == possibleRealValues.size() - 1 ? possibleValuesText + possibleValue : possibleValuesText + possibleValue + ", ";
            }
            if (!isPossibleValue) {
                return StringVariableResult.error(config.getString("messages.variableNotPossibleValue").replace("%values%", possibleValuesText), "variableNotPossibleValue");
            }
        }
        String resultValue = null;
        Limitations limitations = variable.getLimitations();
        if (variable.isNumerical()) {
            String minValue;
            String maxValue;
            double value = Double.parseDouble(newValue);
            if (variable.getValueType().equals((Object)ValueType.DOUBLE)) {
                maxValue = limitations.getMaxValue() + "";
                minValue = limitations.getMinValue() + "";
            } else {
                maxValue = (long)limitations.getMaxValue() + "";
                minValue = (long)limitations.getMinValue() + "";
            }
            if (value > limitations.getMaxValue()) {
                if (!limitations.isManageOutOfRange()) {
                    return StringVariableResult.error(config.getString("messages.variableLimitationOutOfRangeMax").replace("%value%", maxValue), "variableLimitationOutOfRangeMax");
                }
                resultValue = maxValue;
            }
            if (value < limitations.getMinValue()) {
                if (!limitations.isManageOutOfRange()) {
                    return StringVariableResult.error(config.getString("messages.variableLimitationOutOfRangeMin").replace("%value%", minValue), "variableLimitationOutOfRangeMin");
                }
                resultValue = minValue;
            }
        } else {
            int maxCharacters = limitations.getMaxCharacters();
            if (newValue.length() > maxCharacters) {
                return StringVariableResult.error(config.getString("messages.variableLimitationMaxCharactersError").replace("%value%", maxCharacters + ""), "variableLimitationMaxCharactersError");
            }
        }
        return StringVariableResult.noErrorsWithVariable(resultValue, variable);
    }

    public String variableTransformations(Variable variable, String newValue) {
        if (!variable.getValueType().equals((Object)ValueType.DOUBLE)) {
            return newValue;
        }
        int maxDecimals = variable.getLimitations().getMaxDecimals();
        return new BigDecimal(newValue).setScale(maxDecimals, RoundingMode.HALF_UP).toString();
    }

    public String getDisplayFromVariableValue(Variable variable, String value) {
        List<String> possibleValues = variable.getPossibleValues();
        for (String possibleValue : possibleValues) {
            String[] fullValue = possibleValue.split(";");
            if (!fullValue[0].equals(value) || fullValue.length <= 1) continue;
            return fullValue[1];
        }
        return value;
    }
}

