/*
 * Decompiled with CFR 0.152.
 */
package svar.ajneb97.model;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import svar.ajneb97.model.ServerVariablesListVariable;
import svar.ajneb97.model.ServerVariablesStringVariable;
import svar.ajneb97.model.ServerVariablesVariable;
import svar.ajneb97.model.structure.ListVariable;
import svar.ajneb97.model.structure.StringVariable;
import svar.ajneb97.model.structure.Variable;

public class ServerVariablesPlayer {
    private UUID uuid;
    private String name;
    private Map<String, ServerVariablesVariable> variables;
    private boolean modified;

    public ServerVariablesPlayer(UUID uuid, String name, Map<String, ServerVariablesVariable> variables) {
        this.uuid = uuid;
        this.name = name;
        this.variables = variables;
        this.modified = false;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, ServerVariablesVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, ServerVariablesVariable> variables) {
        this.variables = variables;
    }

    public void addVariable(ServerVariablesVariable variable) {
        this.variables.put(variable.getVariableName(), variable);
    }

    public ServerVariablesVariable getCurrentVariable(String variableName) {
        return this.variables.get(variableName);
    }

    public String getVariableStringValue(String variableName, StringVariable variable) {
        ServerVariablesStringVariable v = (ServerVariablesStringVariable)this.getCurrentVariable(variableName);
        if (v == null) {
            return variable.getInitialValue();
        }
        return v.getCurrentValue();
    }

    public List<String> getVariableListValue(String variableName, ListVariable variable) {
        ServerVariablesListVariable v = (ServerVariablesListVariable)this.getCurrentVariable(variableName);
        if (v == null) {
            return variable.getInitialValue();
        }
        return v.getCurrentValue();
    }

    public Object getVariableValue(String variableName, Variable variable) {
        ServerVariablesVariable v = this.getCurrentVariable(variableName);
        if (v == null) {
            return variable.getInitialValue();
        }
        return v.getCurrentValue();
    }

    public void setVariableString(String variableName, String newValue) {
        ServerVariablesStringVariable v = (ServerVariablesStringVariable)this.getCurrentVariable(variableName);
        if (v == null) {
            v = new ServerVariablesStringVariable(variableName, newValue);
            this.variables.put(v.getVariableName(), v);
        } else {
            v.setCurrentValue(newValue);
        }
        this.modified = true;
    }

    public void setVariableList(String variableName, String newValue) {
        ServerVariablesStringVariable v = (ServerVariablesStringVariable)this.getCurrentVariable(variableName);
        if (v == null) {
            v = new ServerVariablesStringVariable(variableName, newValue);
            this.variables.put(v.getVariableName(), v);
        } else {
            v.setCurrentValue(newValue);
        }
        this.modified = true;
    }

    public ServerVariablesVariable resetVariable(String variableName) {
        ServerVariablesVariable removed = this.variables.remove(variableName);
        if (removed != null) {
            this.modified = true;
        }
        return removed;
    }
}

