/*
 * Decompiled with CFR 0.152.
 */
package svar.ajneb97.model.structure;

import java.util.ArrayList;
import java.util.List;
import svar.ajneb97.model.structure.Limitations;
import svar.ajneb97.model.structure.ValueType;
import svar.ajneb97.model.structure.VariableType;

public abstract class Variable {
    private String name;
    private VariableType variableType;
    private ValueType valueType;
    private List<String> possibleValues;
    private Limitations limitations;

    public Variable(String name, VariableType variableType, ValueType valueType, List<String> possibleValues, Limitations limitations) {
        this.name = name;
        this.variableType = variableType;
        this.valueType = valueType;
        this.possibleValues = possibleValues;
        this.limitations = limitations;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public List<String> getPossibleValues() {
        return this.possibleValues;
    }

    public List<String> getPossibleRealValues() {
        ArrayList<String> list = new ArrayList<String>();
        for (String value : this.possibleValues) {
            String realValue = value.split(";")[0];
            list.add(realValue);
        }
        return list;
    }

    public Limitations getLimitations() {
        return this.limitations;
    }

    public void setLimitations(Limitations limitations) {
        this.limitations = limitations;
    }

    public boolean isNumerical() {
        return this.valueType.equals((Object)ValueType.INTEGER) || this.valueType.equals((Object)ValueType.DOUBLE);
    }

    public abstract Object getInitialValue();
}

