/*
 * Decompiled with CFR 0.152.
 */
package svar.ajneb97.config;

import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.configuration.file.FileConfiguration;
import svar.ajneb97.ServerVariables;
import svar.ajneb97.config.DataConfigManager;
import svar.ajneb97.config.MainConfigManager;
import svar.ajneb97.config.PlayersConfigsManager;
import svar.ajneb97.config.VariablesFolderConfigManager;
import svar.ajneb97.config.model.CommonConfig;
import svar.ajneb97.model.structure.Limitations;
import svar.ajneb97.model.structure.ListVariable;
import svar.ajneb97.model.structure.StringVariable;
import svar.ajneb97.model.structure.ValueType;
import svar.ajneb97.model.structure.Variable;
import svar.ajneb97.model.structure.VariableType;

public class ConfigsManager {
    private PlayersConfigsManager playerConfigsManager;
    private DataConfigManager dataConfigManager;
    private MainConfigManager mainConfigManager;
    private VariablesFolderConfigManager variablesFolderConfigManager;
    private ServerVariables plugin;

    public ConfigsManager(ServerVariables plugin) {
        this.plugin = plugin;
        this.mainConfigManager = new MainConfigManager(plugin);
        this.playerConfigsManager = new PlayersConfigsManager(plugin, "players");
        this.dataConfigManager = new DataConfigManager(plugin);
        this.variablesFolderConfigManager = new VariablesFolderConfigManager(plugin, "variables");
    }

    public void configure() {
        this.mainConfigManager.configure();
        this.playerConfigsManager.configure();
        this.variablesFolderConfigManager.configure();
        this.configureVariables();
        this.dataConfigManager.configure();
    }

    public void configureVariables() {
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        ArrayList<CommonConfig> variablesConfigs = this.getVariablesConfigs();
        for (CommonConfig customConfig : variablesConfigs) {
            FileConfiguration config = customConfig.getConfig();
            if (!config.contains("variables")) continue;
            for (String key : config.getConfigurationSection("variables").getKeys(false)) {
                String path = "variables." + key;
                VariableType variableType = VariableType.valueOf(config.getString(path + ".variable_type"));
                ValueType valueType = ValueType.valueOf(config.getString(path + ".value_type"));
                ArrayList<String> possibleValues = new ArrayList();
                if (config.contains(path + ".possible_values")) {
                    possibleValues = config.getStringList(path + ".possible_values");
                }
                Limitations limitations = new Limitations();
                if (config.contains(path + ".limitations.min_value")) {
                    limitations.setMinValue(config.getDouble(path + ".limitations.min_value"));
                }
                if (config.contains(path + ".limitations.max_value")) {
                    limitations.setMaxValue(config.getDouble(path + ".limitations.max_value"));
                }
                if (config.contains(path + ".limitations.max_characters")) {
                    limitations.setMaxCharacters(config.getInt(path + ".limitations.max_characters"));
                }
                if (config.contains(path + ".limitations.max_decimals")) {
                    limitations.setMaxDecimals(config.getInt(path + ".limitations.max_decimals"));
                }
                if (config.contains(path + ".limitations.manage_out_of_range")) {
                    limitations.setManageOutOfRange(config.getBoolean(path + ".limitations.manage_out_of_range"));
                }
                if (valueType.equals((Object)ValueType.LIST)) {
                    variables.put(key, new ListVariable(key, variableType, valueType, possibleValues, limitations, config.getStringList(path + ".initial_value")));
                    continue;
                }
                variables.put(key, new StringVariable(key, variableType, valueType, possibleValues, limitations, config.getString(path + ".initial_value")));
            }
        }
        this.plugin.getVariablesManager().setVariables(variables);
    }

    public PlayersConfigsManager getPlayerConfigsManager() {
        return this.playerConfigsManager;
    }

    public DataConfigManager getDataConfigManager() {
        return this.dataConfigManager;
    }

    public MainConfigManager getMainConfigManager() {
        return this.mainConfigManager;
    }

    private ArrayList<CommonConfig> getVariablesConfigs() {
        ArrayList<CommonConfig> configs = new ArrayList<CommonConfig>();
        configs.add(this.mainConfigManager.getConfigFile());
        configs.addAll(this.variablesFolderConfigManager.getConfigs());
        return configs;
    }

    public boolean reloadConfigs() {
        if (!this.mainConfigManager.reloadConfig()) {
            return false;
        }
        this.configureVariables();
        this.saveServerData();
        this.savePlayerData();
        return true;
    }

    public void savePlayerData() {
        if (this.plugin.getMySQLConnection() == null) {
            this.playerConfigsManager.saveConfigs();
        }
    }

    public void saveServerData() {
        this.dataConfigManager.saveData();
    }
}

