/*
 * Decompiled with CFR 0.152.
 */
package svar.ajneb97.api;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import svar.ajneb97.ServerVariables;
import svar.ajneb97.api.ServerVariablesAPI;
import svar.ajneb97.model.StringVariableResult;

public class ServerVariablesExpansion
extends PlaceholderExpansion {
    private ServerVariables plugin;

    public ServerVariablesExpansion(ServerVariables plugin) {
        this.plugin = plugin;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return "Ajneb97";
    }

    public String getIdentifier() {
        return "servervariables";
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (identifier.startsWith("list_")) {
            String subIdentifier;
            String identifierM = identifier.replace("list_", "");
            String[] sep = identifierM.split("_");
            switch (subIdentifier = sep[0]) {
                case "globalvalue": {
                    int index = Integer.parseInt(sep[1]);
                    String variableName = identifierM.substring(identifierM.indexOf(index + "_") + (index + "_").length());
                    StringVariableResult result = ServerVariablesAPI.getListVariableValueAtIndex(variableName, index);
                    return result.getResultValue() != null ? result.getResultValue() : result.getErrorKey();
                }
                case "globaldisplay": {
                    int index = Integer.parseInt(sep[1]);
                    String variableName = identifierM.substring(identifierM.indexOf(index + "_") + (index + "_").length());
                    return ServerVariablesAPI.getListVariableDisplayAtIndex(variableName, index);
                }
                case "value": {
                    if (player == null) {
                        return "";
                    }
                    int index = Integer.parseInt(sep[1]);
                    String variableName = identifierM.substring(identifierM.indexOf(index + "_") + (index + "_").length());
                    StringVariableResult result = ServerVariablesAPI.getListVariableValueAtIndex(player.getName(), variableName, index);
                    return result.getResultValue() != null ? result.getResultValue() : result.getErrorKey();
                }
                case "display": {
                    if (player == null) {
                        return "";
                    }
                    int index = Integer.parseInt(sep[1]);
                    String variableName = identifierM.substring(identifierM.indexOf(index + "_") + (index + "_").length());
                    return ServerVariablesAPI.getListVariableDisplayAtIndex(player.getName(), variableName, index);
                }
                case "globallength": {
                    String variableName = identifierM.replace("globallength_", "");
                    return ServerVariablesAPI.getListVariableLength(variableName) + "";
                }
                case "length": {
                    if (player == null) {
                        return "";
                    }
                    String variableName = identifierM.replace("length_", "");
                    return ServerVariablesAPI.getListVariableLength(player.getName(), variableName) + "";
                }
                case "globalcontains": {
                    String variableName = identifierM.replace("globalcontains_", "");
                    String[] sep2 = variableName.split(":");
                    return ServerVariablesAPI.listVariableContainsValue(sep2[0], sep2[1]) + "";
                }
                case "contains": {
                    if (player == null) {
                        return "";
                    }
                    String variableName = identifierM.replace("contains_", "");
                    String[] sep2 = variableName.split(":");
                    return ServerVariablesAPI.listVariableContainsValue(player.getName(), sep2[0], sep2[1]) + "";
                }
            }
        } else {
            if (identifier.startsWith("globalvalue_")) {
                String variableName = identifier.replace("globalvalue_", "");
                StringVariableResult result = ServerVariablesAPI.getVariableValue(variableName);
                return result.getResultValue() != null ? result.getResultValue() : result.getErrorKey();
            }
            if (identifier.startsWith("globaldisplay_")) {
                String variableName = identifier.replace("globaldisplay_", "");
                return ServerVariablesAPI.getVariableDisplay(variableName);
            }
            if (identifier.startsWith("value_otherplayer_")) {
                String variable;
                int index;
                String var = identifier.replace("value_otherplayer_", "");
                String playerName = var.substring(0, index = var.indexOf(":"));
                StringVariableResult result = ServerVariablesAPI.getVariableValue(playerName, variable = var.substring(index + 1));
                return result.getResultValue() != null ? result.getResultValue() : result.getErrorKey();
            }
            if (identifier.startsWith("display_otherplayer_")) {
                String var = identifier.replace("display_otherplayer_", "");
                int index = var.indexOf(":");
                String playerName = var.substring(0, index);
                String variable = var.substring(index + 1);
                return ServerVariablesAPI.getVariableValue(playerName, variable).getResultValue();
            }
            if (identifier.startsWith("value_")) {
                if (player == null) {
                    return "";
                }
                String variableName = identifier.replace("value_", "");
                StringVariableResult result = ServerVariablesAPI.getVariableValue(player.getName(), variableName);
                return result.getResultValue() != null ? result.getResultValue() : result.getErrorKey();
            }
            if (identifier.startsWith("display_")) {
                if (player == null) {
                    return "";
                }
                String variableName = identifier.replace("display_", "");
                return ServerVariablesAPI.getVariableDisplay(player.getName(), variableName);
            }
            if (identifier.startsWith("initial_value_")) {
                String variableName = identifier.replace("initial_value_", "");
                return ServerVariablesAPI.getStringVariableInitialValue(variableName);
            }
        }
        return null;
    }
}

