/*
 * Decompiled with CFR 0.152.
 */
package svar.ajneb97.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import svar.ajneb97.ServerVariables;
import svar.ajneb97.database.MySQLConnection;
import svar.ajneb97.model.ListVariableResult;
import svar.ajneb97.model.ServerVariablesPlayer;
import svar.ajneb97.model.ServerVariablesVariable;
import svar.ajneb97.model.StringVariableResult;

public class PlayerVariablesManager {
    private ServerVariables plugin;
    private Map<UUID, ServerVariablesPlayer> playerVariables;
    private Map<String, UUID> playerNames;

    public PlayerVariablesManager(ServerVariables plugin) {
        this.plugin = plugin;
        this.playerNames = new HashMap<String, UUID>();
    }

    public Map<UUID, ServerVariablesPlayer> getPlayerVariables() {
        return this.playerVariables;
    }

    public void setPlayerVariables(Map<UUID, ServerVariablesPlayer> playerVariables) {
        this.playerVariables = playerVariables;
        for (Map.Entry<UUID, ServerVariablesPlayer> entry : playerVariables.entrySet()) {
            this.playerNames.put(entry.getValue().getName(), entry.getKey());
        }
    }

    public void addPlayer(ServerVariablesPlayer p) {
        this.playerVariables.put(p.getUuid(), p);
        this.playerNames.put(p.getName(), p.getUuid());
    }

    private void updatePlayerName(String oldName, String newName, UUID uuid) {
        if (oldName != null) {
            this.playerNames.remove(oldName);
        }
        this.playerNames.put(newName, uuid);
    }

    public ServerVariablesPlayer getPlayerByUUID(UUID uuid) {
        return this.playerVariables.get(uuid);
    }

    private UUID getPlayerUUID(String name) {
        return this.playerNames.get(name);
    }

    public ServerVariablesPlayer getPlayerByName(String name) {
        UUID uuid = this.getPlayerUUID(name);
        return this.playerVariables.get(uuid);
    }

    public void removePlayerByUUID(UUID uuid) {
        this.playerVariables.remove(uuid);
    }

    public void setJoinPlayerData(Player player) {
        if (this.plugin.getMySQLConnection() != null) {
            MySQLConnection mySQLConnection = this.plugin.getMySQLConnection();
            UUID uuid = player.getUniqueId();
            mySQLConnection.getPlayer(uuid.toString(), playerData -> {
                this.removePlayerByUUID(uuid);
                if (playerData != null) {
                    this.addPlayer(playerData);
                    if (!playerData.getName().equals(player.getName())) {
                        this.updatePlayerName(playerData.getName(), player.getName(), player.getUniqueId());
                        playerData.setName(player.getName());
                        mySQLConnection.updatePlayerName(playerData);
                    }
                } else {
                    playerData = new ServerVariablesPlayer(uuid, player.getName(), new HashMap<String, ServerVariablesVariable>());
                    this.addPlayer(playerData);
                    mySQLConnection.createPlayer(playerData);
                }
            });
        } else {
            ServerVariablesPlayer p = this.getPlayerByUUID(player.getUniqueId());
            if (p != null) {
                if (p.getName() == null || !p.getName().equals(player.getName())) {
                    this.updatePlayerName(p.getName(), player.getName(), player.getUniqueId());
                    p.setName(player.getName());
                    p.setModified(true);
                }
            } else {
                p = new ServerVariablesPlayer(player.getUniqueId(), player.getName(), new HashMap<String, ServerVariablesVariable>());
                p.setModified(true);
                this.addPlayer(p);
            }
        }
    }

    public StringVariableResult setVariable(UUID uuid, String variableName, String newValue) {
        ServerVariablesPlayer variablesPlayer = this.getPlayerByUUID(uuid);
        return this.plugin.getVariablesManager().setVariableValue(variablesPlayer.getName(), variableName, newValue);
    }

    public StringVariableResult setVariable(String playerName, String variableName, String newValue) {
        return this.plugin.getVariablesManager().setVariableValue(playerName, variableName, newValue);
    }

    public StringVariableResult getVariableValue(UUID uuid, String variableName, boolean modifying) {
        ServerVariablesPlayer variablesPlayer = this.getPlayerByUUID(uuid);
        return this.plugin.getVariablesManager().getVariableValue(variablesPlayer.getName(), variableName, modifying);
    }

    public StringVariableResult getVariableValue(String playerName, String variableName, boolean modifying) {
        return this.plugin.getVariablesManager().getVariableValue(playerName, variableName, modifying);
    }

    public StringVariableResult setListVariableAtIndex(UUID uuid, String variableName, int index, String newValue) {
        ServerVariablesPlayer variablesPlayer = this.getPlayerByUUID(uuid);
        return this.plugin.getVariablesManager().getListVariablesManager().setListVariableValue(variablesPlayer.getName(), variableName, index, newValue, false);
    }

    public StringVariableResult setListVariableAtIndex(String playerName, String variableName, int index, String newValue) {
        return this.plugin.getVariablesManager().getListVariablesManager().setListVariableValue(playerName, variableName, index, newValue, false);
    }

    public StringVariableResult getListVariableValueAtIndex(UUID uuid, String variableName, int index) {
        ServerVariablesPlayer variablesPlayer = this.getPlayerByUUID(uuid);
        return this.plugin.getVariablesManager().getListVariablesManager().getListVariableValueAtIndex(variablesPlayer.getName(), variableName, index);
    }

    public StringVariableResult getListVariableValueAtIndex(String playerName, String variableName, int index) {
        return this.plugin.getVariablesManager().getListVariablesManager().getListVariableValueAtIndex(playerName, variableName, index);
    }

    public ListVariableResult getListVariableValue(UUID uuid, String variableName) {
        ServerVariablesPlayer variablesPlayer = this.getPlayerByUUID(uuid);
        return this.plugin.getVariablesManager().getListVariablesManager().getListVariableValue(variablesPlayer.getName(), variableName, false);
    }

    public ListVariableResult getListVariableValue(String playerName, String variableName) {
        return this.plugin.getVariablesManager().getListVariablesManager().getListVariableValue(playerName, variableName, false);
    }
}

