/*
 * Decompiled with CFR 0.152.
 */
package com.limitedlife.commands;

import com.limitedlife.LimitedLife;
import com.limitedlife.managers.LifeManager;
import java.util.UUID;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LifeCommand
implements CommandExecutor {
    private final LimitedLife plugin;

    public LifeCommand(LimitedLife plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        LifeManager lifeManager = this.plugin.getLifeManager();
        if (args.length == 0) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                int lives = lifeManager.getLives(player.getUniqueId());
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "You have " + lives + " lives remaining.");
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /lives <player> [set/add/remove] [amount]");
            return false;
        }
        if (args.length == 1) {
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                return false;
            }
            int lives = lifeManager.getLives(target.getUniqueId());
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + target.getName() + " has " + lives + " lives remaining.");
            return true;
        }
        if (args.length == 3 && sender.hasPermission("limitedlife.admin")) {
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                return false;
            }
            UUID targetUUID = target.getUniqueId();
            int currentLives = lifeManager.getLives(targetUUID);
            try {
                int amount = Integer.parseInt(args[2]);
                switch (args[1].toLowerCase()) {
                    case "set": {
                        lifeManager.setLives(targetUUID, amount);
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set " + target.getName() + "'s lives to " + amount);
                        break;
                    }
                    case "add": {
                        lifeManager.setLives(targetUUID, currentLives + amount);
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Added " + amount + " lives to " + target.getName());
                        break;
                    }
                    case "remove": {
                        lifeManager.setLives(targetUUID, currentLives - amount);
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed " + amount + " lives from " + target.getName());
                        break;
                    }
                    default: {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown action. Use set, add, or remove.");
                        return false;
                    }
                }
                lifeManager.saveData();
                if (lifeManager.isPlayerBanned(targetUUID) && target.isOnline()) {
                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(target.getName(), "Out of lives - Permadeath activated", null, null);
                    target.kickPlayer(String.valueOf(ChatColor.RED) + "You have lost all your lives! You are banned from the server.");
                    Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.RED) + target.getName() + " has lost all their lives and has been banned from the server!"));
                }
                return true;
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number: " + args[2]);
                return false;
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /lives [player] [set/add/remove] [amount]");
        return false;
    }
}

