/*
 * Decompiled with CFR 0.152.
 */
package com.limitedlife.listeners;

import com.limitedlife.LimitedLife;
import com.limitedlife.managers.LifeManager;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDeathListener
implements Listener {
    private final LimitedLife plugin;

    public PlayerDeathListener(LimitedLife plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player deadPlayer = event.getEntity();
        LifeManager lifeManager = this.plugin.getLifeManager();
        lifeManager.decrementLives(deadPlayer.getUniqueId());
        int remainingLives = lifeManager.getLives(deadPlayer.getUniqueId());
        if (remainingLives <= 0) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(deadPlayer.getName(), "Out of lives - Permadeath activated", null, null);
                deadPlayer.kickPlayer(String.valueOf(ChatColor.RED) + "You have lost all your lives! You are now banned from the server.");
            });
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.RED) + deadPlayer.getName() + " has lost all their lives and has been banned from the server!"));
        } else {
            deadPlayer.sendMessage(String.valueOf(ChatColor.RED) + "You died! You have " + remainingLives + " lives remaining.");
        }
        if (deadPlayer.getKiller() != null && deadPlayer.getKiller() instanceof Player) {
            Player killer = deadPlayer.getKiller();
            lifeManager.incrementLives(killer.getUniqueId());
            int killerLives = lifeManager.getLives(killer.getUniqueId());
            killer.sendMessage(String.valueOf(ChatColor.GREEN) + "You gained a life for killing " + deadPlayer.getName() + "! You now have " + killerLives + " lives.");
            lifeManager.updatePlayerNameColor(killer.getUniqueId());
        }
        lifeManager.saveData();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        LifeManager lifeManager = this.plugin.getLifeManager();
        if (lifeManager.isPlayerBanned(player.getUniqueId())) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), "Out of lives - Permadeath activated", null, null);
                player.kickPlayer(String.valueOf(ChatColor.RED) + "You have lost all your lives! You are banned from the server.");
            });
            return;
        }
        lifeManager.updatePlayerNameColor(player.getUniqueId());
        int lives = lifeManager.getLives(player.getUniqueId());
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "Welcome! You have " + lives + " lives remaining.");
    }
}

