/*
 * Decompiled with CFR 0.152.
 */
package com.limitedlife.managers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LifeManager {
    private static final int MAX_LIVES = 10;
    private final Plugin plugin;
    private final File configFile;
    private FileConfiguration config;
    private final Map<UUID, Integer> playerLives = new HashMap<UUID, Integer>();

    public LifeManager(Plugin plugin, File configFile) {
        this.plugin = plugin;
        this.configFile = configFile;
        this.loadData();
    }

    public void loadData() {
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create player lives file!");
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        if (this.config.contains("players")) {
            for (String uuidString : this.config.getConfigurationSection("players").getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidString);
                    int lives = this.config.getInt("players." + uuidString);
                    this.playerLives.put(uuid, lives);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid UUID in player lives file: " + uuidString);
                }
            }
        }
    }

    public void saveData() {
        if (this.config == null) {
            this.config = new YamlConfiguration();
        }
        for (Map.Entry<UUID, Integer> entry : this.playerLives.entrySet()) {
            this.config.set("players." + entry.getKey().toString(), (Object)entry.getValue());
        }
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save player lives file!");
            e.printStackTrace();
        }
    }

    public int getLives(UUID playerUUID) {
        return this.playerLives.getOrDefault(playerUUID, 10);
    }

    public void setLives(UUID playerUUID, int lives) {
        this.playerLives.put(playerUUID, Math.max(0, Math.min(lives, 10)));
        this.updatePlayerNameColor(playerUUID);
    }

    public void decrementLives(UUID playerUUID) {
        int currentLives = this.getLives(playerUUID);
        this.setLives(playerUUID, currentLives - 1);
    }

    public void incrementLives(UUID playerUUID) {
        int currentLives = this.getLives(playerUUID);
        if (currentLives < 10) {
            this.setLives(playerUUID, currentLives + 1);
        }
    }

    public boolean isPlayerBanned(UUID playerUUID) {
        return this.getLives(playerUUID) <= 0;
    }

    public void updatePlayerNameColor(UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player != null && player.isOnline()) {
            int lives = this.getLives(playerUUID);
            ChatColor color = this.getColorForLives(lives);
            String displayName = String.valueOf(color) + player.getName();
            player.setDisplayName(displayName);
            player.setPlayerListName(displayName);
        }
    }

    public ChatColor getColorForLives(int lives) {
        if (lives <= 0) {
            return ChatColor.DARK_RED;
        }
        if (lives == 1) {
            return ChatColor.RED;
        }
        if (lives <= 3) {
            return ChatColor.GOLD;
        }
        if (lives <= 6) {
            return ChatColor.YELLOW;
        }
        if (lives <= 9) {
            return ChatColor.GREEN;
        }
        return ChatColor.DARK_GREEN;
    }

    public void updateAllPlayerColors() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updatePlayerNameColor(player.getUniqueId());
        }
    }
}

