/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity;

import com.yuushya.modelling.block.AbstractYuushyaBlock;
import com.yuushya.modelling.block.blockstate.YuushyaBlockStates;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTransformBlock
extends AbstractYuushyaBlock
implements EntityBlock {
    public static final BooleanProperty ENABLE_AO = BooleanProperty.create((String)"enable_ao");
    public static final Boolean DEFAULT_ENABLE_AO = false;

    public AbstractTransformBlock(BlockBehaviour.Properties properties, Integer tipLines) {
        super(properties, tipLines);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)YuushyaBlockStates.LIT, (Comparable)Integer.valueOf(0))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)ENABLE_AO, (Comparable)DEFAULT_ENABLE_AO));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{YuushyaBlockStates.LIT}).add(new Property[]{BlockStateProperties.POWERED}).add(new Property[]{BlockStateProperties.HORIZONTAL_FACING}).add(new Property[]{YuushyaBlockStates.SHAPES}).add(new Property[]{ENABLE_AO});
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        if (blockPlaceContext.getPlayer() != null && blockPlaceContext.getPlayer().isHolding((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"rot_trans_item")))) {
            BlockState blockState = this.defaultBlockState();
            blockState.setValue((Property)ENABLE_AO, (Comparable)DEFAULT_ENABLE_AO);
            return blockPlaceContext.getClickedFace().getAxis() == Direction.Axis.Y ? (BlockState)blockState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)blockPlaceContext.getHorizontalDirection()) : (BlockState)blockState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)blockPlaceContext.getClickedFace().getOpposite());
        }
        return super.getStateForPlacement(blockPlaceContext);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }
}

