/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.yuushya.modelling.blockentity.AbstractTransformBlockEntity;
import com.yuushya.modelling.blockentity.transformData.ITransformDataProvider;
import com.yuushya.modelling.utils.YuushyaUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;

public abstract class AbstractTransformBlockEntityRender<T extends AbstractTransformBlockEntity>
implements BlockEntityRenderer<T> {
    public static final Vector3d MIDDLE = new Vector3d(8.0, 8.0, 8.0);
    public static final Vector3d _MIDDLE = new Vector3d(-8.0, -8.0, -8.0);
    protected final Font font;
    protected final BlockEntityRenderDispatcher blockEntityRenderDispatcher;

    public AbstractTransformBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
        this.blockEntityRenderDispatcher = context.getBlockEntityRenderDispatcher();
    }

    public static void renderText(Font font, Component component, float high, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, Camera camera) {
        matrixStack.pushPose();
        Quaternionf quaternion = new Quaternionf().rotationYXZ((float)(-Math.PI) / 180 * AbstractTransformBlockEntityRender.cameraYRot(camera), (float)Math.PI / 180 * AbstractTransformBlockEntityRender.cameraXRot(camera), 0.0f);
        matrixStack.mulPose(quaternion);
        matrixStack.translate(2.0f, 2.0f + high, 1.0f);
        matrixStack.scale(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrixStack.last().pose();
        float g = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int backgroundColor = (int)(g * 255.0f) << 24;
        font.drawInBatch(component, 0.0f, 0.0f, -1, false, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, backgroundColor, 0xF000F0);
        matrixStack.popPose();
    }

    private static float cameraYRot(Camera camera) {
        return camera.getYRot();
    }

    private static float cameraXRot(Camera camera) {
        return camera.getXRot();
    }

    protected void renderFrame(T blockEntity, PoseStack matrixStack, MultiBufferSource multiBufferSource) {
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.lines());
        LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)vertexConsumer, (double)-0.01, (double)-0.01, (double)-0.01, (double)1.01, (double)1.01, (double)1.01, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        ((AbstractTransformBlockEntity)((Object)blockEntity)).consumeShowFrame();
    }

    protected void renderAxes(T blockEntity, PoseStack matrixStack, MultiBufferSource multiBufferSource, ITransformDataProvider transformData) {
        this.renderAxes(blockEntity, matrixStack, multiBufferSource, transformData.getPosition(), transformData.getRotation(), transformData.getScale());
    }

    protected void renderAxes(T blockEntity, PoseStack matrixStack, MultiBufferSource multiBufferSource, Vector3d pos, Vector3f rot, Vector3f scales) {
        matrixStack.pushPose();
        Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        float f = facing.toYRot();
        matrixStack.translate(0.5f, 0.5f, 0.5f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(-f));
        matrixStack.translate(-0.5f, -0.5f, -0.5f);
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)8.0f);
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        YuushyaUtils.translateAfterScale(matrixStack, pos, scales);
        YuushyaUtils.translate(matrixStack, MIDDLE);
        boolean showRotAxis = ((AbstractTransformBlockEntity)((Object)blockEntity)).showRotAxis();
        int redX = 1692817990;
        int greenY = 1688263770;
        int blueZ = 1683666140;
        if (((AbstractTransformBlockEntity)((Object)blockEntity)).getShowAxis() != null) {
            switch (((AbstractTransformBlockEntity)((Object)blockEntity)).getShowAxis()) {
                case X: {
                    redX = -1680826;
                    break;
                }
                case Y: {
                    greenY = -6235046;
                    break;
                }
                case Z: {
                    blueZ = -10832676;
                }
            }
        }
        if (showRotAxis) {
            matrixStack.mulPose(Axis.ZP.rotationDegrees(rot.z()));
        }
        bufferBuilder.addVertex(matrixStack.last().pose(), 0.0f, 0.0f, -1.5f).setColor(blueZ).setNormal(0.0f, 0.0f, 1.5f);
        bufferBuilder.addVertex(matrixStack.last().pose(), 0.0f, 0.0f, 1.5f).setColor(blueZ).setNormal(0.0f, 0.0f, 1.5f);
        if (showRotAxis) {
            matrixStack.mulPose(Axis.YP.rotationDegrees(rot.y()));
        }
        bufferBuilder.addVertex(matrixStack.last().pose(), 0.0f, -1.5f, 0.0f).setColor(greenY).setNormal(0.0f, 1.5f, 0.0f);
        bufferBuilder.addVertex(matrixStack.last().pose(), 0.0f, 1.5f, 0.0f).setColor(greenY).setNormal(0.0f, 1.5f, 0.0f);
        if (showRotAxis) {
            matrixStack.mulPose(Axis.XP.rotationDegrees(rot.x()));
        }
        bufferBuilder.addVertex(matrixStack.last().pose(), -1.5f, 0.0f, 0.0f).setColor(redX).setNormal(1.5f, 0.0f, 0.0f);
        bufferBuilder.addVertex(matrixStack.last().pose(), 1.5f, 0.0f, 0.0f).setColor(redX).setNormal(1.5f, 0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        matrixStack.popPose();
    }

    public void render(T blockEntity, float tickDelta, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        if (((AbstractTransformBlockEntity)((Object)blockEntity)).showFrame()) {
            this.renderFrame(blockEntity, matrixStack, multiBufferSource);
        }
        if (((AbstractTransformBlockEntity)((Object)blockEntity)).showRotAxis() || ((AbstractTransformBlockEntity)((Object)blockEntity)).showPosAxis() || ((AbstractTransformBlockEntity)((Object)blockEntity)).showText()) {
            this.renderSpecific(blockEntity, tickDelta, matrixStack, multiBufferSource, light, overlay);
            ((AbstractTransformBlockEntity)((Object)blockEntity)).consumeShow();
            ((AbstractTransformBlockEntity)((Object)blockEntity)).consumeShowAxis();
        }
    }

    protected abstract void renderSpecific(T var1, float var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);
}

