/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.itemblock;

import com.yuushya.modelling.block.blockstate.YuushyaBlockStates;
import com.yuushya.modelling.blockentity.AbstractTransformBlock;
import com.yuushya.modelling.blockentity.BlockShape;
import com.yuushya.modelling.blockentity.itemblock.ItemBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlock
extends AbstractTransformBlock {
    public ItemBlock(BlockBehaviour.Properties properties, Integer tipLines) {
        super(properties, tipLines);
    }

    @OnlyIn(value=Dist.CLIENT)
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity;
        if (level.getBlockState(pos).is(state.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof ItemBlockEntity) {
            ItemBlockEntity itemBlockEntity = (ItemBlockEntity)blockEntity;
            if (context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"gui_item")))) {
                itemBlockEntity.setShowFrame();
            } else if (context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"rot_trans_item")))) {
                itemBlockEntity.setShowRotAxis();
                itemBlockEntity.setShowText();
            } else if (context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"pos_trans_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"micro_pos_trans_item")))) {
                itemBlockEntity.setShowPosAxis();
                itemBlockEntity.setShowText();
            } else if (context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"slot_trans_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"get_showblock_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"move_transformdata_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"get_blockstate_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"scale_trans_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"debug_stick_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"destroy_item")))) {
                itemBlockEntity.setShowText();
            }
        }
        return super.getShape(state, level, pos, context);
    }

    @NotNull
    protected VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return ((BlockShape)((Object)blockState.getValue(YuushyaBlockStates.SHAPES))).voxelShape;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ItemBlockEntity(blockPos, blockState);
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        this.spawnDestroyParticles(level, player, pos, state);
        return state;
    }
}

