/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.itemblock;

import com.yuushya.modelling.block.blockstate.YuushyaBlockStates;
import com.yuushya.modelling.blockentity.AbstractTransformBlock;
import com.yuushya.modelling.blockentity.AbstractTransformBlockEntity;
import com.yuushya.modelling.blockentity.BlockShape;
import com.yuushya.modelling.blockentity.transformData.ITransformItemDataInventory;
import com.yuushya.modelling.blockentity.transformData.TransformItemData;
import com.yuushya.modelling.registries.YuushyaRegistries;
import com.yuushya.modelling.utils.CustomRenderInstance;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockEntity
extends AbstractTransformBlockEntity
implements ITransformItemDataInventory {
    private final List<TransformItemData> transformData = new ArrayList<TransformItemData>();

    public ItemBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)YuushyaRegistries.ITEM_BLOCK_ENTITY.get(), blockPos, blockState);
        this.transformData.add(new TransformItemData());
        this.slot = 0;
    }

    @NotNull
    public TransformItemData getTransFormDataNow() {
        return this.getTransformData(this.slot);
    }

    @Override
    public void setSlot(int slot) {
        if (slot >= this.transformData.size()) {
            for (int i = slot - this.transformData.size() + 1; i > 0; --i) {
                this.transformData.add(new TransformItemData());
            }
        }
        this.slot = slot;
    }

    @Override
    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        super.loadAdditional(compoundTag, registries);
        ITransformItemDataInventory.load(compoundTag, this.transformData, registries);
    }

    @Override
    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        super.saveAdditional(compoundTag, registries);
        ITransformItemDataInventory.saveAdditional(compoundTag, this.transformData, registries);
    }

    @Override
    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Override
    public void writeBlockState(ItemStack itemStack, BlockState blockState) {
        BlockItemStateProperties blockItemStateProperties = BlockItemStateProperties.EMPTY;
        itemStack.set(DataComponents.BLOCK_STATE, (Object)blockItemStateProperties.with((Property)YuushyaBlockStates.LIT, (Comparable)((Integer)blockState.getValue((Property)YuushyaBlockStates.LIT))).with(YuushyaBlockStates.SHAPES, (Comparable)((Object)((BlockShape)((Object)blockState.getValue(YuushyaBlockStates.SHAPES))))).with((Property)AbstractTransformBlock.ENABLE_AO, (Comparable)((Boolean)blockState.getValue((Property)AbstractTransformBlock.ENABLE_AO))));
    }

    public void setRemoved() {
        CustomRenderInstance.getINSTANCE().dirty = true;
        super.setRemoved();
    }

    @Override
    @Generated
    public List<TransformItemData> getTransformData() {
        return this.transformData;
    }
}

