/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.itemblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yuushya.modelling.blockentity.AbstractTransformBlockEntityRender;
import com.yuushya.modelling.blockentity.itemblock.ItemBlockEntity;
import com.yuushya.modelling.blockentity.transformData.TransformItemData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public class ItemBlockEntityRender
extends AbstractTransformBlockEntityRender<ItemBlockEntity> {
    public ItemBlockEntityRender(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSpecific(ItemBlockEntity blockEntity, float tickDelta, PoseStack matrixStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        TransformItemData transformData = blockEntity.getTransFormDataNow();
        if (transformData.isShown && (blockEntity.showPosAxis() || blockEntity.showRotAxis())) {
            this.renderAxes(blockEntity, matrixStack, multiBufferSource, transformData);
        }
        if (blockEntity.showText()) {
            this.renderTextInfo(blockEntity, transformData, matrixStack, multiBufferSource, light);
        }
    }

    private void renderTextInfo(ItemBlockEntity blockEntity, TransformItemData transformData, PoseStack matrixStack, MultiBufferSource multiBufferSource, int light) {
        matrixStack.pushPose();
        Camera camera = this.blockEntityRenderDispatcher.camera;
        ItemBlockEntityRender.renderText(this.font, (Component)Component.translatable((String)"block.yuushya.itemblock.pos_text").append((Component)Component.translatable((String)"block.yuushya.itemblock.x", (Object[])new Object[]{String.format("%05.1f", transformData.pos.x)}).withStyle(ChatFormatting.DARK_RED)).append((Component)Component.translatable((String)"block.yuushya.itemblock.y", (Object[])new Object[]{String.format("%05.1f", transformData.pos.y)}).withStyle(ChatFormatting.GREEN)).append((Component)Component.translatable((String)"block.yuushya.itemblock.z", (Object[])new Object[]{String.format("%05.1f", transformData.pos.z)}).withStyle(ChatFormatting.BLUE)), 0.8f, matrixStack, multiBufferSource, light, camera);
        ItemBlockEntityRender.renderText(this.font, (Component)Component.translatable((String)"block.yuushya.itemblock.rot_text").append((Component)Component.translatable((String)"block.yuushya.itemblock.x", (Object[])new Object[]{String.format("%05.1f", Float.valueOf(transformData.rot.x()))}).withStyle(ChatFormatting.DARK_RED)).append((Component)Component.translatable((String)"block.yuushya.itemblock.y", (Object[])new Object[]{String.format("%05.1f", Float.valueOf(transformData.rot.y()))}).withStyle(ChatFormatting.GREEN)).append((Component)Component.translatable((String)"block.yuushya.itemblock.z", (Object[])new Object[]{String.format("%05.1f", Float.valueOf(transformData.rot.z()))}).withStyle(ChatFormatting.BLUE)), 0.55f, matrixStack, multiBufferSource, light, camera);
        ItemBlockEntityRender.renderText(this.font, (Component)Component.translatable((String)"block.yuushya.itemblock.scale_text", (Object[])new Object[]{Float.valueOf(transformData.scales.x())}), 0.3f, matrixStack, multiBufferSource, light, camera);
        float high = 0.3f;
        for (TransformItemData everyTransformData : blockEntity.getTransformData()) {
            int slot = blockEntity.getTransformData().indexOf(everyTransformData);
            Style style = blockEntity.getSlot() == slot ? Style.EMPTY.withColor(ChatFormatting.GOLD).withBold(Boolean.valueOf(true)) : (everyTransformData.isShown ? Style.EMPTY.withColor(ChatFormatting.WHITE) : Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true)));
            ItemStack itemStack = everyTransformData.itemStack;
            MutableComponent displayName = itemStack.isEmpty() ? Component.literal((String)"Air") : (MutableComponent)itemStack.getDisplayName();
            MutableComponent component = Component.translatable((String)"block.yuushya.itemblock.slot_text", (Object[])new Object[]{String.format("%2d", slot)}).append((Component)displayName.withStyle(style));
            ItemBlockEntityRender.renderText(this.font, (Component)component, high -= 0.25f, matrixStack, multiBufferSource, light, camera);
        }
        matrixStack.popPose();
    }
}

