/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.itemblock;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockModel
implements BakedModel,
UnbakedModel {
    protected final Direction facing;
    protected final BakedModel backup;

    public ItemBlockModel(Direction facing) {
        this.facing = facing;
        this.backup = this;
    }

    public ItemBlockModel(Direction facing, BakedModel backup) {
        this.facing = facing;
        this.backup = backup;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction side, RandomSource rand) {
        if (this.backup != this) {
            return this.backup.getQuads(blockState, side, rand);
        }
        return Collections.emptyList();
    }

    public boolean useAmbientOcclusion() {
        if (this.backup != this) {
            return this.backup.usesBlockLight();
        }
        return false;
    }

    public boolean isGui3d() {
        if (this.backup != this) {
            return this.backup.isGui3d();
        }
        return true;
    }

    public boolean usesBlockLight() {
        if (this.backup != this) {
            return this.backup.usesBlockLight();
        }
        return false;
    }

    public boolean isCustomRenderer() {
        if (this.backup != this) {
            return this.backup.isCustomRenderer();
        }
        return false;
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        if (this.backup != this) {
            return this.backup.getParticleIcon();
        }
        return Minecraft.getInstance().getBlockRenderer().getBlockModel(Blocks.IRON_BLOCK.defaultBlockState()).getParticleIcon();
    }

    @NotNull
    public ItemTransforms getTransforms() {
        if (this.backup != this) {
            return this.backup.getTransforms();
        }
        return Minecraft.getInstance().getBlockRenderer().getBlockModel(Blocks.IRON_BLOCK.defaultBlockState()).getTransforms();
    }

    @NotNull
    public ItemOverrides getOverrides() {
        if (this.backup != this) {
            return this.backup.getOverrides();
        }
        return ItemOverrides.EMPTY;
    }

    @NotNull
    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    @Nullable
    public BakedModel bake(ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState state) {
        return this;
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> function) {
    }

    @Generated
    public Direction getFacing() {
        return this.facing;
    }
}

