/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.showblock;

import com.yuushya.modelling.block.blockstate.YuushyaBlockStates;
import com.yuushya.modelling.blockentity.AbstractTransformBlock;
import com.yuushya.modelling.blockentity.BlockShape;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowBlock
extends AbstractTransformBlock {
    public ShowBlock(BlockBehaviour.Properties properties, Integer tipLines) {
        super(properties, tipLines);
    }

    @OnlyIn(value=Dist.CLIENT)
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity;
        if (level.getBlockState(pos).is(state.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof ShowBlockEntity) {
            ShowBlockEntity showBlockEntity = (ShowBlockEntity)blockEntity;
            if (context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"gui_item")))) {
                showBlockEntity.setShowFrame();
            } else if (context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"rot_trans_item")))) {
                showBlockEntity.setShowRotAxis();
                showBlockEntity.setShowText();
            } else if (context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"pos_trans_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"micro_pos_trans_item")))) {
                showBlockEntity.setShowPosAxis();
                showBlockEntity.setShowText();
            } else if (context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"slot_trans_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"get_showblock_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"move_transformdata_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"get_blockstate_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"scale_trans_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"debug_stick_item"))) || context.isHoldingItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"destroy_item")))) {
                showBlockEntity.setShowText();
            }
        }
        return super.getShape(state, level, pos, context);
    }

    @NotNull
    protected VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return ((BlockShape)((Object)blockState.getValue(YuushyaBlockStates.SHAPES))).voxelShape;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ShowBlockEntity(blockPos, blockState);
    }

    @NotNull
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockEntity blockEntity = worldIn.getBlockEntity(currentPos);
        if (blockEntity instanceof ShowBlockEntity) {
            ShowBlockEntity showBlockEntity = (ShowBlockEntity)blockEntity;
            BlockState blockState = showBlockEntity.getTransformData((int)0).blockState;
            Block block = blockState.getBlock();
            if (facingState.getBlock() instanceof ShowBlock) {
                showBlockEntity.saveChanged();
                return stateIn;
            }
            if (!(block instanceof AirBlock)) {
                showBlockEntity.getTransformData((int)0).blockState = blockState.updateShape(facing, facingState, worldIn, currentPos, facingPos);
                showBlockEntity.saveChanged();
                return (BlockState)stateIn.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf((Boolean)stateIn.getValue((Property)BlockStateProperties.POWERED) == false));
            }
            showBlockEntity.saveChanged();
        }
        return (BlockState)stateIn.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf((Boolean)stateIn.getValue((Property)BlockStateProperties.POWERED) == false));
    }
}

