/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.showblock;

import com.yuushya.modelling.block.blockstate.YuushyaBlockStates;
import com.yuushya.modelling.blockentity.AbstractTransformBlockEntity;
import com.yuushya.modelling.blockentity.BlockShape;
import com.yuushya.modelling.blockentity.transformData.ITransformDataInventory;
import com.yuushya.modelling.blockentity.transformData.TransformBlockData;
import com.yuushya.modelling.registries.YuushyaRegistries;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ShowBlockEntity
extends AbstractTransformBlockEntity
implements ITransformDataInventory {
    private final List<TransformBlockData> transformData = new ArrayList<TransformBlockData>();

    @NotNull
    public TransformBlockData getTransFormDataNow() {
        return this.getTransformData(this.slot);
    }

    public void removeTransFormDataNow() {
        this.removeTransformData(this.slot);
    }

    public void setTransformDataNow(TransformBlockData transformData) {
        this.setTransformData(this.slot, transformData);
    }

    public void setSlotBlockStateNow(BlockState blockState) {
        this.setSlotBlockState(this.slot, blockState);
    }

    @Override
    public void setSlot(int slot) {
        if (slot >= this.transformData.size()) {
            for (int i = slot - this.transformData.size() + 1; i > 0; --i) {
                this.transformData.add(new TransformBlockData());
            }
        }
        this.slot = slot;
    }

    public ShowBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)YuushyaRegistries.SHOW_BLOCK_ENTITY.get(), blockPos, blockState);
        this.transformData.add(new TransformBlockData());
        this.slot = 0;
    }

    @Override
    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        super.loadAdditional(compoundTag, registries);
        ITransformDataInventory.load(compoundTag, this.transformData);
    }

    @Override
    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        super.saveAdditional(compoundTag, registries);
        ITransformDataInventory.saveAdditional(compoundTag, this.transformData, registries);
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag compoundTag = super.getUpdateTag(registries);
        ITransformDataInventory.saveAdditional(compoundTag, this.transformData, registries);
        return compoundTag;
    }

    @Override
    public void writeBlockState(ItemStack itemStack, BlockState blockState) {
        BlockItemStateProperties blockItemStateProperties = BlockItemStateProperties.EMPTY;
        itemStack.set(DataComponents.BLOCK_STATE, (Object)blockItemStateProperties.with((Property)YuushyaBlockStates.LIT, (Comparable)((Integer)blockState.getValue((Property)YuushyaBlockStates.LIT))).with(YuushyaBlockStates.SHAPES, (Comparable)((Object)((BlockShape)((Object)blockState.getValue(YuushyaBlockStates.SHAPES))))));
    }

    @Override
    @Generated
    public List<TransformBlockData> getTransformData() {
        return this.transformData;
    }
}

