/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.showblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yuushya.modelling.blockentity.transformData.TransformBlockData;
import com.yuushya.modelling.utils.YuushyaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class ShowBlockModel
implements BakedModel,
UnbakedModel {
    protected final Direction facing;
    protected final BakedModel backup;

    public ShowBlockModel(Direction facing) {
        this.facing = facing;
        this.backup = this;
    }

    public ShowBlockModel(Direction facing, BakedModel backup) {
        this.facing = facing;
        this.backup = backup;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, List<TransformBlockData> transformDatas) {
        int vertexSize = YuushyaUtils.vertexSize();
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.getInstance().getBlockRenderer();
        ArrayList<BakedQuad> finalQuads = new ArrayList<BakedQuad>();
        if (side != null) {
            return Collections.emptyList();
        }
        ArrayList<Direction> directions = new ArrayList<Direction>(Arrays.asList(Direction.values()));
        directions.add(null);
        float f = this.facing.toYRot();
        PoseStack stack = new PoseStack();
        stack.translate(0.5f, 0.5f, 0.5f);
        stack.mulPose(Axis.YP.rotationDegrees(-f));
        stack.translate(-0.5f, -0.5f, -0.5f);
        for (TransformBlockData transformData : transformDatas) {
            if (!transformData.isShown) continue;
            BlockState blockState = transformData.blockState;
            BakedModel blockModel = blockRenderDispatcher.getBlockModel(blockState);
            for (Direction value : directions) {
                List blockModelQuads = blockModel.getQuads(blockState, value, rand);
                for (BakedQuad bakedQuad : blockModelQuads) {
                    int[] vertex = (int[])bakedQuad.getVertices().clone();
                    stack.pushPose();
                    YuushyaUtils.scale(stack, transformData.scales);
                    YuushyaUtils.translate(stack, transformData.pos);
                    YuushyaUtils.rotate(stack, transformData.rot);
                    for (int i = 0; i < 4; ++i) {
                        Vector4f vector4f = new Vector4f(Float.intBitsToFloat(vertex[vertexSize * i]), Float.intBitsToFloat(vertex[vertexSize * i + 1]), Float.intBitsToFloat(vertex[vertexSize * i + 2]), 1.0f);
                        stack.last().pose().transform(vector4f);
                        vertex[vertexSize * i] = Float.floatToRawIntBits(vector4f.x());
                        vertex[vertexSize * i + 1] = Float.floatToRawIntBits(vector4f.y());
                        vertex[vertexSize * i + 2] = Float.floatToRawIntBits(vector4f.z());
                    }
                    stack.popPose();
                    if (bakedQuad.getTintIndex() > -1) {
                        finalQuads.add(new BakedQuad(vertex, YuushyaUtils.encodeTintWithState(bakedQuad.getTintIndex(), blockState), bakedQuad.getDirection(), bakedQuad.getSprite(), bakedQuad.isShade()));
                        continue;
                    }
                    finalQuads.add(new BakedQuad(vertex, bakedQuad.getTintIndex(), bakedQuad.getDirection(), bakedQuad.getSprite(), bakedQuad.isShade()));
                }
            }
        }
        return finalQuads;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction side, RandomSource rand) {
        if (this.backup != this) {
            return this.backup.getQuads(blockState, side, rand);
        }
        return Collections.emptyList();
    }

    public boolean useAmbientOcclusion() {
        if (this.backup != this) {
            return this.backup.usesBlockLight();
        }
        return false;
    }

    public boolean isGui3d() {
        if (this.backup != this) {
            return this.backup.isGui3d();
        }
        return true;
    }

    public boolean usesBlockLight() {
        if (this.backup != this) {
            return this.backup.usesBlockLight();
        }
        return false;
    }

    public boolean isCustomRenderer() {
        if (this.backup != this) {
            return this.backup.isCustomRenderer();
        }
        return false;
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        if (this.backup != this) {
            return this.backup.getParticleIcon();
        }
        return Minecraft.getInstance().getBlockRenderer().getBlockModel(Blocks.IRON_BLOCK.defaultBlockState()).getParticleIcon();
    }

    @NotNull
    public ItemTransforms getTransforms() {
        if (this.backup != this) {
            return this.backup.getTransforms();
        }
        return Minecraft.getInstance().getBlockRenderer().getBlockModel(Blocks.IRON_BLOCK.defaultBlockState()).getTransforms();
    }

    @NotNull
    public ItemOverrides getOverrides() {
        if (this.backup != this) {
            return this.backup.getOverrides();
        }
        return ItemOverrides.EMPTY;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    @Nullable
    public BakedModel bake(ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState state) {
        return this;
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> function) {
    }
}

