/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.transformData;

import com.yuushya.modelling.blockentity.transformData.ITransformDataProvider;
import com.yuushya.modelling.blockentity.transformData.TransformBlockData;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public interface ITransformDataInventory {
    public static ITransformDataInventory of(List<TransformBlockData> transformDatas) {
        return () -> transformDatas;
    }

    public static void load(CompoundTag compoundTag, List<TransformBlockData> transformDatas) {
        ListTag listTag = compoundTag.getList("Blocks", 10);
        if (!transformDatas.isEmpty()) {
            transformDatas.clear();
        }
        for (int index = 0; index < listTag.size(); ++index) {
            TransformBlockData transformData = new TransformBlockData();
            CompoundTag compoundTagTemp = listTag.getCompound(index);
            transformData.load(compoundTagTemp);
            transformDatas.add(transformData);
        }
        if (transformDatas.isEmpty()) {
            transformDatas.add(new TransformBlockData());
        }
    }

    public static void saveAdditional(CompoundTag compoundTag, List<? extends ITransformDataProvider> transformDatas, HolderLookup.Provider registries) {
        ListTag listTag = new ListTag();
        int index = 0;
        for (ITransformDataProvider iTransformDataProvider : transformDatas) {
            CompoundTag compoundTagTemp = new CompoundTag();
            compoundTagTemp.putByte("Slot", (byte)index);
            iTransformDataProvider.saveAdditional(compoundTagTemp, registries);
            listTag.add((Object)compoundTagTemp);
            ++index;
        }
        if (!listTag.isEmpty()) {
            compoundTag.put("Blocks", (Tag)listTag);
        }
    }

    public static void saveAdditionalWithoutAir(CompoundTag compoundTag, List<TransformBlockData> transformDatas, HolderLookup.Provider registries) {
        ListTag listTag = new ListTag();
        int index = 0;
        for (TransformBlockData transformData : transformDatas) {
            if (!(transformData.blockState.getBlock() instanceof AirBlock)) {
                CompoundTag compoundTagTemp = new CompoundTag();
                compoundTagTemp.putByte("Slot", (byte)index);
                transformData.saveAdditional(compoundTagTemp, registries);
                listTag.add((Object)compoundTagTemp);
            }
            ++index;
        }
        if (!listTag.isEmpty()) {
            compoundTag.put("Blocks", (Tag)listTag);
        }
    }

    public List<TransformBlockData> getTransformData();

    default public int size() {
        return this.getTransformData().size();
    }

    default public boolean isEmpty() {
        for (TransformBlockData transformData : this.getTransformData()) {
            if (transformData.blockState.getBlock() instanceof AirBlock) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public TransformBlockData getTransformData(int slot) {
        if (slot < this.size()) {
            return this.getTransformData().get(slot);
        }
        return this.getTransformData().get(Math.min(this.size() - 1, 0));
    }

    default public void addTransformData(int slot, TransformBlockData transformData) {
        if (slot < this.size()) {
            this.getTransformData().add(slot, transformData);
        } else {
            this.getTransformData().add(transformData);
        }
    }

    default public void addTransformData(TransformBlockData transformData) {
        this.getTransformData().add(transformData);
    }

    default public void removeTransformData(int slot) {
        this.getTransformData(slot).set();
    }

    default public void removeSlotBlockState(int slot) {
        this.getTransformData((int)slot).blockState = Blocks.AIR.defaultBlockState();
    }

    default public void setTransformData(int slot, TransformBlockData transformData) {
        this.getTransformData(slot).set(transformData);
    }

    default public void setSlotBlockState(int slot, BlockState blockState) {
        this.getTransformData((int)slot).blockState = blockState;
    }

    default public void setSlotShown(int slot, boolean isShown) {
        this.getTransformData((int)slot).isShown = isShown;
    }

    default public void clear() {
        this.getTransformData().clear();
    }
}

