/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.transformData;

import com.yuushya.modelling.blockentity.transformData.TransformItemData;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public interface ITransformItemDataInventory {
    public static ITransformItemDataInventory of(List<TransformItemData> transformDatas) {
        return () -> transformDatas;
    }

    public static void load(CompoundTag compoundTag, List<TransformItemData> transformDatas, HolderLookup.Provider registries) {
        ListTag listTag = compoundTag.getList("Blocks", 10);
        if (!transformDatas.isEmpty()) {
            transformDatas.clear();
        }
        for (int index = 0; index < listTag.size(); ++index) {
            TransformItemData transformData = new TransformItemData();
            CompoundTag compoundTagTemp = listTag.getCompound(index);
            transformData.load(compoundTagTemp, registries);
            transformDatas.add(transformData);
        }
        if (transformDatas.isEmpty()) {
            transformDatas.add(new TransformItemData());
        }
    }

    public static void saveAdditional(CompoundTag compoundTag, List<TransformItemData> transformDatas, HolderLookup.Provider registries) {
        ListTag listTag = new ListTag();
        int index = 0;
        for (TransformItemData transformData : transformDatas) {
            CompoundTag compoundTagTemp = new CompoundTag();
            compoundTagTemp.putByte("Slot", (byte)index);
            transformData.saveAdditional(compoundTagTemp, registries);
            listTag.add((Object)compoundTagTemp);
            ++index;
        }
        if (!listTag.isEmpty()) {
            compoundTag.put("Blocks", (Tag)listTag);
        }
    }

    public static void saveAdditionalWithoutAir(CompoundTag compoundTag, List<TransformItemData> transformDatas, HolderLookup.Provider registries) {
        ListTag listTag = new ListTag();
        int index = 0;
        for (TransformItemData transformData : transformDatas) {
            if (!transformData.itemStack.isEmpty()) {
                CompoundTag compoundTagTemp = new CompoundTag();
                compoundTagTemp.putByte("Slot", (byte)index);
                transformData.saveAdditional(compoundTagTemp, registries);
                listTag.add((Object)compoundTagTemp);
            }
            ++index;
        }
        if (!listTag.isEmpty()) {
            compoundTag.put("Blocks", (Tag)listTag);
        }
    }

    public List<TransformItemData> getTransformData();

    default public int size() {
        return this.getTransformData().size();
    }

    default public boolean isEmpty() {
        Iterator<TransformItemData> iterator = this.getTransformData().iterator();
        if (iterator.hasNext()) {
            TransformItemData transformData = iterator.next();
            return transformData.itemStack.isEmpty();
        }
        return true;
    }

    @NotNull
    default public TransformItemData getTransformData(int slot) {
        if (slot < this.size()) {
            return this.getTransformData().get(slot);
        }
        return this.getTransformData().get(Math.min(this.size() - 1, 0));
    }

    default public void addTransformData(int slot, TransformItemData transformData) {
        if (slot < this.size()) {
            this.getTransformData().add(slot, transformData);
        } else {
            this.getTransformData().add(transformData);
        }
    }

    default public void addTransformData(TransformItemData transformData) {
        this.getTransformData().add(transformData);
    }

    default public void removeTransformData(int slot) {
        this.getTransformData(slot).set();
    }

    default public void removeSlotBlockState(int slot) {
        this.getTransformData((int)slot).itemStack = Items.AIR.getDefaultInstance();
    }

    default public void setTransformData(int slot, TransformItemData transformData) {
        this.getTransformData(slot).set(transformData);
    }

    default public void setSlotBlockState(int slot, ItemStack itemStack) {
        this.getTransformData((int)slot).itemStack = itemStack;
    }

    default public void setSlotShown(int slot, boolean isShown) {
        this.getTransformData((int)slot).isShown = isShown;
    }

    default public void clear() {
        this.getTransformData().clear();
    }
}

