/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.transformData;

import com.yuushya.modelling.block.blockstate.YuushyaBlockStates;
import com.yuushya.modelling.blockentity.BlockShape;
import com.yuushya.modelling.blockentity.itemblock.ItemBlockEntity;
import com.yuushya.modelling.blockentity.transformData.TransformItemData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public enum ItemTransformType {
    POS_X(0),
    POS_Y(1),
    POS_Z(2),
    ROT_X(3),
    ROT_Y(4),
    ROT_Z(5),
    SCALE_X(6),
    SCALE_Y(7),
    SCALE_Z(8),
    ITEM_STACK(9),
    SHOWN(10),
    LIT(11),
    REMOVE(12),
    SUCCESS(13),
    FAIL(14),
    SHAPE(15),
    COLOR(16);

    public final int type;

    private ItemTransformType(int i) {
        this.type = i;
    }

    public double extract(TransformItemData transformData) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> transformData.pos.x();
            case 1 -> transformData.pos.y();
            case 2 -> transformData.pos.z();
            case 3 -> transformData.rot.x();
            case 4 -> transformData.rot.y();
            case 5 -> transformData.rot.z();
            case 6 -> transformData.scales.x();
            case 7 -> transformData.scales.y();
            case 8 -> transformData.scales.z();
            case 16 -> transformData.color;
            case 9 -> Item.getId((Item)transformData.itemStack.getItem());
            case 10 -> {
                if (transformData.isShown) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case 11, 12, 13, 14, 15 -> 0.0;
        };
    }

    public void modify(TransformItemData transformData, Double number) {
        switch (this.ordinal()) {
            case 0: {
                transformData.pos.set(number.doubleValue(), transformData.pos.y(), transformData.pos.z());
                break;
            }
            case 1: {
                transformData.pos.set(transformData.pos.x(), number.doubleValue(), transformData.pos.z());
                break;
            }
            case 2: {
                transformData.pos.set(transformData.pos.x(), transformData.pos.y(), number.doubleValue());
                break;
            }
            case 3: {
                transformData.rot.set(number.floatValue(), transformData.rot.y(), transformData.rot.z());
                break;
            }
            case 4: {
                transformData.rot.set(transformData.rot.x(), number.floatValue(), transformData.rot.z());
                break;
            }
            case 5: {
                transformData.rot.set(transformData.rot.x(), transformData.rot.y(), number.floatValue());
                break;
            }
            case 6: {
                transformData.scales.set(number.floatValue(), transformData.scales.y(), transformData.scales.z());
                break;
            }
            case 7: {
                transformData.scales.set(transformData.scales.x(), number.floatValue(), transformData.scales.z());
                break;
            }
            case 8: {
                transformData.scales.set(transformData.scales.x(), transformData.scales.y(), number.floatValue());
                break;
            }
            case 16: {
                transformData.color = number.intValue();
                break;
            }
            case 10: {
                transformData.isShown = number != 0.0;
                break;
            }
        }
    }

    public void modifyItem(TransformItemData transformData, int slot, ItemStack stack) {
        transformData.itemStack = stack;
    }

    public double extract(ItemBlockEntity itemBlockEntity, int slot) {
        if (this == LIT) {
            return ((Integer)itemBlockEntity.getBlockState().getValue((Property)YuushyaBlockStates.LIT)).intValue();
        }
        return this.extract(itemBlockEntity.getTransformData(slot));
    }

    public BlockShape extractShape(ItemBlockEntity itemBlockEntity) {
        return (BlockShape)((Object)itemBlockEntity.getBlockState().getValue(YuushyaBlockStates.SHAPES));
    }

    public void modify(ItemBlockEntity itemBlockEntity, int slot, double number) {
        if (itemBlockEntity.getLevel() == null) {
            return;
        }
        if (this == SUCCESS) {
            itemBlockEntity.saveChanged();
            return;
        }
        if (this == LIT) {
            Level level = itemBlockEntity.getLevel();
            level.setBlock(itemBlockEntity.getBlockPos(), (BlockState)itemBlockEntity.getBlockState().setValue((Property)YuushyaBlockStates.LIT, (Comparable)Integer.valueOf((int)Math.round(number))), 18);
            return;
        }
        if (this == REMOVE) {
            itemBlockEntity.removeTransformData(slot);
            return;
        }
        if (this == SHAPE) {
            Level level = itemBlockEntity.getLevel();
            level.setBlock(itemBlockEntity.getBlockPos(), (BlockState)itemBlockEntity.getBlockState().setValue(YuushyaBlockStates.SHAPES, (Comparable)((Object)BlockShape.values()[(int)number])), 18);
            return;
        }
        itemBlockEntity.setSlot(slot);
        this.modify(itemBlockEntity.getTransformData(slot), number);
    }

    public void modify(ItemBlockEntity itemBlockEntity, int slot, ItemStack itemStack) {
        if (itemBlockEntity.getLevel() == null) {
            return;
        }
        itemBlockEntity.setSlot(slot);
        this.modifyItem(itemBlockEntity.getTransformData(slot), slot, itemStack);
    }
}

