/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.transformData;

import com.yuushya.modelling.blockentity.transformData.ITransformDataProvider;
import com.yuushya.modelling.utils.YuushyaUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class TransformBlockData
implements ITransformDataProvider {
    public Vector3d pos = new Vector3d(0.0, 0.0, 0.0);
    public Vector3f rot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f scales = new Vector3f(1.0f, 1.0f, 1.0f);
    public BlockState blockState = Blocks.AIR.defaultBlockState();
    public boolean isShown = false;

    public TransformBlockData() {
    }

    public TransformBlockData(Vector3d pos, Vector3f rot, Vector3f scales, BlockState blockState, boolean isShown) {
        this();
        this.pos.set((Vector3dc)pos);
        this.rot.set(rot.x(), rot.y(), rot.z());
        this.scales.set(scales.x(), scales.y(), scales.z());
        this.blockState = blockState;
        this.isShown = isShown;
    }

    public void set(Vector3d pos, Vector3f rot, Vector3f scales, BlockState blockState, boolean isShown) {
        this.pos.set((Vector3dc)pos);
        this.rot.set(rot.x(), rot.y(), rot.z());
        this.scales.set(scales.x(), scales.y(), scales.z());
        this.blockState = blockState;
        this.isShown = isShown;
    }

    public void set(TransformBlockData old) {
        this.set(old.pos, old.rot, old.scales, old.blockState, old.isShown);
    }

    public void set() {
        this.pos.set(0.0, 0.0, 0.0);
        this.rot.set(0.0f, 0.0f, 0.0f);
        this.scales.set(1.0f, 1.0f, 1.0f);
        this.blockState = Blocks.AIR.defaultBlockState();
        this.isShown = false;
    }

    public void load(CompoundTag compoundTag) {
        ListTag listTagPos = compoundTag.getList("ShowPos", 6);
        ListTag listTagRot = compoundTag.getList("ShowRotation", 5);
        ListTag listTagScales = compoundTag.getList("ShowScales", 5);
        this.pos.set(listTagPos.getDouble(0), listTagPos.getDouble(1), listTagPos.getDouble(2));
        this.rot.set(listTagRot.getFloat(0), listTagRot.getFloat(1), listTagRot.getFloat(2));
        this.scales.set(listTagScales.getFloat(0), listTagScales.getFloat(1), listTagScales.getFloat(2));
        this.isShown = compoundTag.getBoolean("isShown");
        this.blockState = YuushyaUtils.readBlockState(compoundTag.getCompound("BlockState"));
    }

    @Override
    public void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        compoundTag.put("ShowPos", (Tag)YuushyaUtils.toListTag(this.pos.x, this.pos.y, this.pos.z));
        compoundTag.put("ShowRotation", (Tag)YuushyaUtils.toListTag(Float.valueOf(this.rot.x()), Float.valueOf(this.rot.y()), Float.valueOf(this.rot.z())));
        compoundTag.put("ShowScales", (Tag)YuushyaUtils.toListTag(Float.valueOf(this.scales.x()), Float.valueOf(this.scales.y()), Float.valueOf(this.scales.z())));
        compoundTag.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.blockState));
        compoundTag.put("isShown", (Tag)ByteTag.valueOf((boolean)this.isShown));
    }

    @Override
    public Vector3d getPosition() {
        return this.pos;
    }

    @Override
    public Vector3f getRotation() {
        return this.rot;
    }

    @Override
    public Vector3f getScale() {
        return this.scales;
    }

    @Override
    public boolean isShown() {
        return this.isShown;
    }

    @Override
    public void setShown(boolean shown) {
        this.isShown = shown;
    }
}

