/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.transformData;

import com.yuushya.modelling.blockentity.transformData.ITransformDataProvider;
import com.yuushya.modelling.utils.YuushyaUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class TransformItemData
implements ITransformDataProvider {
    public Vector3d pos = new Vector3d(0.0, 0.0, 0.0);
    public Vector3f rot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f scales = new Vector3f(1.0f, 1.0f, 1.0f);
    public int color = FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
    public ItemStack itemStack = Items.AIR.getDefaultInstance();
    public boolean isShown = false;

    public TransformItemData() {
    }

    public TransformItemData(Vector3d pos, Vector3f rot, Vector3f scales, ItemStack ItemStack2, int color, boolean isShown) {
        this();
        this.pos.set((Vector3dc)pos);
        this.rot.set(rot.x(), rot.y(), rot.z());
        this.scales.set(scales.x(), scales.y(), scales.z());
        this.itemStack = ItemStack2;
        this.color = color;
        this.isShown = isShown;
    }

    public void set(Vector3d pos, Vector3f rot, Vector3f scales, ItemStack ItemStack2, int color, boolean isShown) {
        this.pos.set((Vector3dc)pos);
        this.rot.set(rot.x(), rot.y(), rot.z());
        this.scales.set(scales.x(), scales.y(), scales.z());
        this.itemStack = ItemStack2;
        this.color = color;
        this.isShown = isShown;
    }

    public void set(TransformItemData old) {
        this.set(old.pos, old.rot, old.scales, old.itemStack, old.color, old.isShown);
    }

    public void set() {
        this.pos.set(0.0, 0.0, 0.0);
        this.rot.set(0.0f, 0.0f, 0.0f);
        this.scales.set(1.0f, 1.0f, 1.0f);
        this.itemStack = Items.AIR.getDefaultInstance();
        this.isShown = false;
    }

    public void load(CompoundTag compoundTag, HolderLookup.Provider registries) {
        ListTag listTagPos = compoundTag.getList("ShowPos", 6);
        ListTag listTagRot = compoundTag.getList("ShowRotation", 6);
        ListTag listTagScales = compoundTag.getList("ShowScales", 6);
        this.pos.set(listTagPos.getDouble(0), listTagPos.getDouble(1), listTagPos.getDouble(2));
        this.rot.set(listTagRot.getDouble(0), listTagRot.getDouble(1), listTagRot.getDouble(2));
        this.scales.set(listTagScales.getDouble(0), listTagScales.getDouble(1), listTagScales.getDouble(2));
        this.itemStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compoundTag.getCompound("ItemStack"));
        this.color = compoundTag.getInt("Color");
        this.isShown = compoundTag.getBoolean("isShown");
    }

    @Override
    public void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        compoundTag.put("ShowPos", (Tag)YuushyaUtils.toListTag(this.pos.x, this.pos.y, this.pos.z));
        compoundTag.put("ShowRotation", (Tag)YuushyaUtils.toDoubleListTag(this.rot));
        compoundTag.put("ShowScales", (Tag)YuushyaUtils.toDoubleListTag(this.scales));
        compoundTag.put("ItemStack", (Tag)YuushyaUtils.itemStackTag(this.itemStack, registries));
        compoundTag.putInt("Color", this.color);
        compoundTag.putBoolean("isShown", this.isShown);
    }

    @Override
    public Vector3d getPosition() {
        return this.pos;
    }

    @Override
    public Vector3f getRotation() {
        return this.rot;
    }

    @Override
    public Vector3f getScale() {
        return this.scales;
    }

    @Override
    public boolean isShown() {
        return this.isShown;
    }

    @Override
    public void setShown(boolean shown) {
        this.isShown = shown;
    }
}

